"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggestUsersRoute = void 0;
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _utils = require("../utils");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const suggestUsersRoute = (router, logger) => router.versioned.post({
  access: 'internal',
  path: _elasticAssistantCommon.ELASTIC_USERS_SUGGEST_URL,
  security: {
    authz: {
      requiredPrivileges: ['elasticAssistant']
    }
  }
}).addVersion({
  version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
  validate: {
    request: {
      body: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.SuggestUsersRequestBody)
    },
    response: {
      200: {
        body: {
          custom: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.SuggestUsersResponse)
        }
      }
    }
  }
}, async (context, request, response) => {
  const assistantResponse = (0, _utils.buildResponse)(response);
  try {
    const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
    // Perform license and authenticated user checks
    const checkResponse = await (0, _helpers.performChecks)({
      context: ctx,
      request,
      response
    });
    if (!checkResponse.isSuccess) {
      return checkResponse.response;
    }
    const spaceId = ctx.elasticAssistant.getSpaceId();
    const {
      searchTerm,
      size
    } = request.body;
    const result = await ctx.elasticAssistant.userProfile.suggest({
      name: searchTerm,
      size,
      dataPath: 'avatar',
      // ensure that the user has the required assistant privileges
      requiredPrivileges: {
        spaceId,
        privileges: {
          kibana: ['securitySolutionAssistant']
        }
      }
    });
    return response.ok({
      body: result
    });
  } catch (err) {
    logger.error(err);
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    return assistantResponse.error({
      body: error.message,
      statusCode: error.statusCode
    });
  }
});
exports.suggestUsersRoute = suggestUsersRoute;