"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGenerateOrRefineOrEndDecision = void 0;
var _get_should_end = require("../get_should_end");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGenerateOrRefineOrEndDecision = ({
  hasUnrefinedResults,
  hasZeroDocs,
  maxHallucinationFailuresReached,
  maxRetriesReached
}) => {
  if ((0, _get_should_end.getShouldEnd)({
    hasZeroDocs,
    maxHallucinationFailuresReached,
    maxRetriesReached
  })) {
    return 'end';
  }
  if (hasUnrefinedResults) {
    return 'refine';
  }
  return 'generate';
};
exports.getGenerateOrRefineOrEndDecision = getGenerateOrRefineOrEndDecision;