"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEsqlDataView = getEsqlDataView;
var _esqlUtils = require("@kbn/esql-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getEsqlDataView(query, currentDataView, services) {
  const indexPatternFromQuery = (0, _esqlUtils.getIndexPatternFromESQLQuery)(query.esql);
  const newTimeField = (0, _esqlUtils.getTimeFieldFromESQLQuery)(query.esql);
  const onlyTimeFieldChanged = indexPatternFromQuery === (currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.getIndexPattern()) && newTimeField !== (currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.timeFieldName);
  if (currentDataView !== null && currentDataView !== void 0 && currentDataView.isPersisted() || indexPatternFromQuery !== (currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.getIndexPattern()) ||
  // here the pattern hasn't changed but the time field has
  onlyTimeFieldChanged) {
    return await (0, _esqlUtils.getESQLAdHocDataview)(query.esql, services.dataViews, {
      // make sure that data view service cache is not used when creating the ES|QL data view,
      // otherwise a single mutated data view instance would be used across tabs (inside currentDataView$) which would be incorrect
      // https://github.com/elastic/kibana/issues/234719
      createNewInstanceEvenIfCachedOneAvailable: !currentDataView || onlyTimeFieldChanged
    });
  }
  return currentDataView;
}