"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntaxSuggestionsPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/no_results/no_results_suggestions/syntax_suggestions_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SyntaxSuggestionsPopover = ({
  meta
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const {
    title,
    items,
    footer
  } = meta;
  const helpButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: () => setIsOpen(prev => !prev),
    iconType: "documentation",
    "aria-label": title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  });
  const columns = [{
    field: 'label',
    name: _i18n.i18n.translate('discover.noResults.suggestion.syntaxPopoverDescriptionHeader', {
      defaultMessage: 'Description'
    }),
    width: '200px'
  }, {
    field: 'example',
    name: _i18n.i18n.translate('discover.noResults.suggestion.syntaxPopoverExampleHeader', {
      defaultMessage: 'Example'
    }),
    render: example => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 36
      }
    }, example)
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: helpButton,
    isOpen: isOpen,
    display: "inlineBlock",
    panelPaddingSize: "none",
    closePopover: () => setIsOpen(false),
    initialFocus: "#querySyntaxBasicTableId",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: "eui-yScroll",
    css: (0, _react2.css)`
          max-height: 40vh;
          max-width: 500px;
        `,
    color: "transparent",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    id: "querySyntaxBasicTableId",
    tableCaption: title,
    items: items,
    compressed: true,
    rowHeader: "label",
    columns: columns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, footer), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  })));
};
exports.SyntaxSuggestionsPopover = SyntaxSuggestionsPopover;