"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = renderApp;
exports.staticStyles = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dev_tools/public/application.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const devAppContainerStyles = (0, _react2.css)`
  flex: 1 1 auto;
  display: flex;
  flex-direction: column;

  > * {
    flex-shrink: 0;
  }
`;
const staticStyles = exports.staticStyles = {
  devAppContainer: devAppContainerStyles,
  devApp: devAppContainerStyles,
  devAppTabBeta: (0, _react2.css)`
    vertical-align: middle;
  `
};
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    ...staticStyles,
    tabs: (0, _react2.css)`
      padding-left: ${euiTheme.size.s};
    `
  };
};
function DevToolsWrapper({
  devTools,
  activeDevTool,
  history,
  appServices,
  location,
  startServices
}) {
  const styles = useStyles();
  const {
    docTitleService,
    breadcrumbService
  } = appServices;
  const mountedTool = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => () => {
    if (mountedTool.current) {
      mountedTool.current.unmountHandler();
    }
  }, []);
  (0, _react.useEffect)(() => {
    docTitleService.setTitle(activeDevTool.title);
    breadcrumbService.setBreadcrumbs(activeDevTool.title);
  }, [activeDevTool, docTitleService, breadcrumbService]);
  return /*#__PURE__*/_react.default.createElement("main", {
    css: styles.devApp,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    css: styles.tabs,
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, devTools.map(currentDevTool => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: currentDevTool.id,
    disabled: currentDevTool.isDisabled(),
    isSelected: currentDevTool === activeDevTool,
    onClick: () => {
      if (!currentDevTool.isDisabled()) {
        history.push(`/${currentDevTool.id}`);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: currentDevTool.tooltipContent,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 15
    }
  }, currentDevTool.title, ' ', currentDevTool.isBeta && /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    size: "s",
    css: styles.devAppTabBeta,
    label: _i18n.i18n.translate('devTools.badge.betaLabel', {
      defaultMessage: 'Beta'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 19
    }
  })))))), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.devAppContainer,
    role: "tabpanel",
    "data-test-subj": activeDevTool.id,
    ref: async element => {
      if (element && (mountedTool.current === null || mountedTool.current.devTool !== activeDevTool || mountedTool.current.mountpoint !== element)) {
        if (mountedTool.current) {
          mountedTool.current.unmountHandler();
        }
        const params = {
          element,
          location,
          history,
          ...startServices
        };
        const unmountHandler = await activeDevTool.mount(params);
        mountedTool.current = {
          devTool: activeDevTool,
          mountpoint: element,
          unmountHandler
        };
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }));
}
function redirectOnMissingCapabilities(application) {
  if (!application.capabilities.dev_tools.show) {
    application.navigateToApp('home');
    return true;
  }
  return false;
}
function setBadge(application, chrome) {
  if (application.capabilities.dev_tools.save) {
    return;
  }
  chrome.setBadge({
    text: _i18n.i18n.translate('devTools.badge.readOnly.text', {
      defaultMessage: 'Read only'
    }),
    tooltip: _i18n.i18n.translate('devTools.badge.readOnly.tooltip', {
      defaultMessage: 'Unable to save'
    }),
    iconType: 'glasses'
  });
}
function renderApp(element, application, chrome, history, devTools, appServices, startServices) {
  if (redirectOnMissingCapabilities(application)) {
    return () => {};
  }
  setBadge(application, chrome);
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, startServices, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.HashRouter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  }, devTools
  // Only create routes for devtools that are not disabled
  .filter(devTool => !devTool.isDisabled()).map(devTool => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    key: devTool.id,
    path: `/${devTool.id}`,
    exact: !devTool.enableRouting,
    render: props => /*#__PURE__*/_react.default.createElement(DevToolsWrapper, {
      history: props.history,
      location: props.location,
      activeDevTool: devTool,
      devTools: devTools,
      appServices: appServices,
      startServices: startServices,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 19
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: `/${devTools[0].id}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 13
    }
  }))))), element);

  // dispatch synthetic hash change event to update hash history objects
  // this is necessary because hash updates triggered by using popState won't trigger this event naturally.
  const unlisten = history.listen(() => {
    window.dispatchEvent(new HashChangeEvent('hashchange'));
  });
  return () => {
    chrome.docTitle.reset();
    _reactDom.default.unmountComponentAtNode(element);
    unlisten();
  };
}