"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandableTruncatedText = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactHooks = require("@kbn/react-hooks");
var _translations = require("../../../../common/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/quality_issue_flyout/expandable_truncated_text.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ExpandableTruncatedText = ({
  text,
  maxCharLength = 150,
  truncatedTextLength = 35,
  codeLanguage
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    displayText,
    isExpanded,
    toggleExpanded,
    shouldTruncate
  } = (0, _reactHooks.useTruncateText)(text, maxCharLength, truncatedTextLength);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    style: {
      width: '100%'
    },
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    language: codeLanguage,
    style: {
      fontWeight: 'normal',
      color: euiTheme.colors.textParagraph,
      overflowWrap: 'break-word'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, displayText), shouldTruncate && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "truncatedTextToggle",
    onClick: toggleExpanded,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, isExpanded ? _translations.readLess : _translations.readMore));
};
exports.ExpandableTruncatedText = ExpandableTruncatedText;