"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QualityIssuesTable = void 0;
var _eui = require("@elastic/eui");
var _fieldTypes = require("@kbn/field-types");
var _react = _interopRequireDefault(require("react"));
var _translations = require("../../../../../common/translations");
var _hooks = require("../../../../hooks");
var _columns = require("./columns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/overview/quality_issues/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const QualityIssuesTable = () => {
  const {
    isDegradedFieldsLoading,
    pagination,
    renderedItems,
    onTableChange,
    sort,
    fieldFormats,
    expandedDegradedField,
    openDegradedFieldFlyout
  } = (0, _hooks.useQualityIssues)();
  const dateFormatter = fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.DATE, [_fieldTypes.ES_FIELD_TYPES.DATE]);
  const columns = (0, _columns.getQualityIssuesColumns)({
    dateFormatter,
    isLoading: isDegradedFieldsLoading,
    expandedQualityIssue: expandedDegradedField,
    openQualityIssueFlyout: openDegradedFieldFlyout
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableLayout: "fixed",
    columns: columns,
    items: renderedItems !== null && renderedItems !== void 0 ? renderedItems : [],
    loading: isDegradedFieldsLoading,
    sorting: sort,
    onChange: onTableChange,
    pagination: pagination,
    "data-test-subj": "datasetQualityDetailsDegradedFieldTable",
    rowProps: {
      'data-test-subj': 'datasetQualityDetailsDegradedTableRow'
    },
    noItemsMessage: isDegradedFieldsLoading ? _translations.overviewDegradedFieldsTableLoadingText : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "datasetQualityDetailsDegradedTableNoData",
      layout: "vertical",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 20
        }
      }, _translations.qualityIssuesTableNoData),
      hasBorder: false,
      titleSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  });
};
exports.QualityIssuesTable = QualityIssuesTable;