"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DatasetQualityDetails;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _hooks = require("../../hooks");
var _index_not_found_prompt = require("./index_not_found_prompt");
var _header = require("./header");
var _overview = require("./overview");
var _details = require("./details");
var _alert_flyout = require("../../alerts/alert_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/dataset_quality_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QualityIssueFlyout = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./quality_issue_flyout'))));

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function DatasetQualityDetails() {
  const {
    isIndexNotFoundError,
    dataStream,
    isQualityIssueFlyoutOpen,
    view
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const {
    startTracking
  } = (0, _hooks.useDatasetDetailsTelemetry)();
  const [ruleType, setRuleType] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    startTracking();
  }, [startTracking]);
  return isIndexNotFoundError ? /*#__PURE__*/_react.default.createElement(_index_not_found_prompt.DataStreamNotFoundPrompt, {
    dataStream: dataStream,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    "data-test-subj": "datasetDetailsContainer",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }, view === 'dataQuality' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header.Header, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_overview.Overview, {
    openAlertFlyout: () => setRuleType(_ruleDataUtils.DEGRADED_DOCS_RULE_TYPE_ID),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  }), view === 'dataQuality' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_details.Details, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 15
    }
  }))), ruleType === _ruleDataUtils.DEGRADED_DOCS_RULE_TYPE_ID && /*#__PURE__*/_react.default.createElement(_alert_flyout.AlertFlyout, {
    dataStream: dataStream,
    closeFlyout: () => setRuleType(null),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  })), isQualityIssueFlyoutOpen && /*#__PURE__*/_react.default.createElement(QualityIssueFlyout, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 36
    }
  }));
}
module.exports = exports.default;