"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexedFieldsTable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _reselect = require("reselect");
var _table = require("./components/table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/edit_index_pattern/indexed_fields_table/indexed_fields_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class IndexedFieldsTable extends _react.Component {
  constructor(_props) {
    super(_props);
    (0, _defineProperty2.default)(this, "getFilteredFields", (0, _reselect.createSelector)(state => state.fields, (_state, props) => props.fieldFilter, (_state, props) => props.indexedFieldTypeFilter, (_state, props) => props.schemaFieldTypeFilter, (fields, fieldFilter, indexedFieldTypeFilter, schemaFieldTypeFilter) => {
      if (fieldFilter) {
        const normalizedFieldFilter = fieldFilter.toLowerCase();
        fields = fields.filter(field => field.name.toLowerCase().includes(normalizedFieldFilter) || field.displayName && field.displayName.toLowerCase().includes(normalizedFieldFilter));
      }
      if (indexedFieldTypeFilter.length) {
        // match conflict fields
        fields = fields.filter(field => {
          var _field$runtimeField, _field$runtimeField2, _field$esTypes;
          if (indexedFieldTypeFilter.includes('conflict') && field.kbnType === 'conflict') {
            return true;
          }
          if ('runtimeField' in field && (_field$runtimeField = field.runtimeField) !== null && _field$runtimeField !== void 0 && _field$runtimeField.type && indexedFieldTypeFilter.includes((_field$runtimeField2 = field.runtimeField) === null || _field$runtimeField2 === void 0 ? void 0 : _field$runtimeField2.type)) {
            return true;
          }
          // match one of multiple types on a field
          return ((_field$esTypes = field.esTypes) === null || _field$esTypes === void 0 ? void 0 : _field$esTypes.length) && field.esTypes.filter(val => indexedFieldTypeFilter.includes(val)).length;
        });
      }
      if (schemaFieldTypeFilter.length) {
        // match fields of schema type
        fields = fields.filter(field => {
          return schemaFieldTypeFilter.includes('runtime') && 'runtimeField' in field || schemaFieldTypeFilter.includes('indexed') && !('runtimeField' in field);
        });
      }
      return fields;
    }));
    this.state = {
      fields: [...this.mapCompositeRuntimeFields(this.props.compositeRuntimeFields), ...this.mapFields(this.props.fields)]
    };
  }
  UNSAFE_componentWillReceiveProps(nextProps) {
    if (nextProps.fields !== this.props.fields || nextProps.compositeRuntimeFields !== this.props.compositeRuntimeFields) {
      this.setState({
        fields: [...this.mapCompositeRuntimeFields(nextProps.compositeRuntimeFields), ...this.mapFields(nextProps.fields)]
      });
    }
  }
  mapFields(fields) {
    const {
      indexPattern,
      fieldWildcardMatcher,
      helpers,
      userEditPermission
    } = this.props;
    const sourceFilters = indexPattern.sourceFilters && indexPattern.sourceFilters.map(f => f.value);
    const fieldWildcardMatch = fieldWildcardMatcher(sourceFilters || []);
    return fields && fields.map(field => {
      var _field$esTypes2, _indexPattern$getForm, _indexPattern$getForm2;
      return {
        ...field.spec,
        id: field.name,
        type: ((_field$esTypes2 = field.esTypes) === null || _field$esTypes2 === void 0 ? void 0 : _field$esTypes2.join(', ')) || '',
        kbnType: field.type,
        displayName: field.displayName,
        format: ((_indexPattern$getForm = indexPattern.getFormatterForFieldNoDefault(field.name)) === null || _indexPattern$getForm === void 0 ? void 0 : (_indexPattern$getForm2 = _indexPattern$getForm.type) === null || _indexPattern$getForm2 === void 0 ? void 0 : _indexPattern$getForm2.title) || '',
        excluded: fieldWildcardMatch ? fieldWildcardMatch(field.name) : false,
        info: helpers.getFieldInfo && helpers.getFieldInfo(indexPattern, field),
        isMapped: !!field.isMapped,
        isUserEditable: userEditPermission,
        hasRuntime: !!field.runtimeField
      };
    }) || [];
  }
  mapCompositeRuntimeFields(compositeRuntimeFields) {
    const {
      indexPattern,
      fieldWildcardMatcher,
      userEditPermission
    } = this.props;
    const sourceFilters = indexPattern.sourceFilters && indexPattern.sourceFilters.map(f => f.value);
    const fieldWildcardMatch = fieldWildcardMatcher(sourceFilters || []);
    return Object.entries(compositeRuntimeFields).map(([name, fld]) => {
      return {
        spec: {
          searchable: false,
          aggregatable: false,
          name,
          type: 'composite',
          runtimeField: {
            type: 'composite',
            script: fld.script,
            fields: fld.fields
          }
        },
        name,
        id: name,
        type: 'composite',
        kbnType: '',
        displayName: name,
        excluded: fieldWildcardMatch ? fieldWildcardMatch(name) : false,
        info: [],
        isMapped: false,
        isUserEditable: userEditPermission,
        hasRuntime: true,
        runtimeField: {
          type: 'composite',
          script: fld.script,
          fields: fld.fields
        }
      };
    });
  }
  render() {
    const {
      indexPattern
    } = this.props;
    const fields = this.getFilteredFields(this.state, this.props);
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_table.Table, {
      indexPattern: indexPattern,
      items: fields,
      editField: field => this.props.helpers.editField(field.name),
      deleteField: fieldNames => this.props.helpers.deleteField(fieldNames),
      openModal: this.props.openModal,
      startServices: this.props.startServices,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 9
      }
    }));
  }
}
exports.IndexedFieldsTable = IndexedFieldsTable;