"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewListItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _field_preview_context = require("../field_preview_context");
var _is_updating_indicator = require("../is_updating_indicator");
var _image_preview_modal = require("../image_preview_modal");
var _state_utils = require("../../../state_utils");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/preview/field_list/field_list_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isLoadingPreviewSelector = state => state.isLoadingPreview;
const PreviewListItem = ({
  field: {
    key,
    value,
    formattedValue,
    isPinned = false
  },
  toggleIsPinned,
  hasScriptError,
  isFromScript = false
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const pinButtonId = `fieldPreview.pinFieldButtonLabel.${key}`;
  const {
    controller
  } = (0, _field_preview_context.useFieldPreviewContext)();
  const isLoadingPreview = (0, _state_utils.useStateSelector)(controller.state$, isLoadingPreviewSelector);
  const [isPreviewImageModalVisible, setIsPreviewImageModalVisible] = (0, _react.useState)(false);
  const [isPinHovered, setIsPinHovered] = (0, _react.useState)(false);
  const [isPinFocused, setIsPinFocused] = (0, _react.useState)(false);
  const showPinIcon = isPinHovered || isPinFocused || isPinned;
  const doesContainImage = formattedValue === null || formattedValue === void 0 ? void 0 : formattedValue.includes('<img');
  const renderName = () => {
    if (isFromScript && !Boolean(key)) {
      return /*#__PURE__*/_react.default.createElement("span", {
        css: styles.lightWeight,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.fieldNameNotSetLabel', {
        defaultMessage: 'Field name not set'
      })));
    }
    return key;
  };
  const withTooltip = content => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: typeof value !== 'string' ? JSON.stringify(value) : value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, content);
  const renderValue = () => {
    if (isFromScript && isLoadingPreview) {
      return /*#__PURE__*/_react.default.createElement("span", {
        css: styles.lightWeight,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_is_updating_indicator.IsUpdatingIndicator, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 11
        }
      }));
    }
    if (hasScriptError) {
      return /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        iconType: "warning",
        color: "danger",
        "data-test-subj": "scriptErrorBadge",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.scriptErrorBadgeLabel', {
        defaultMessage: 'Script error'
      })));
    }
    if (isFromScript && value === undefined) {
      return /*#__PURE__*/_react.default.createElement("span", {
        css: styles.lightWeight,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.valueNotSetLabel', {
        defaultMessage: 'Value not set'
      })));
    }
    if (doesContainImage) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        color: "text",
        onClick: () => setIsPreviewImageModalVisible(true),
        iconType: "image",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 9
        }
      }, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.viewImageButtonLabel', {
        defaultMessage: 'View image'
      }));
    }
    if (formattedValue !== undefined) {
      return withTooltip(/*#__PURE__*/_react.default.createElement("span", {
        css: styles.keyAndValueWrapper
        // We  can dangerously set HTML here because this content is guaranteed to have been run through a valid field formatter first.
        ,
        dangerouslySetInnerHTML: {
          __html: formattedValue
        } // eslint-disable-line react/no-danger
        ,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 9
        }
      }));
    }
    return withTooltip(/*#__PURE__*/_react.default.createElement("span", {
      css: styles.keyAndValueWrapper,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 24
      }
    }, JSON.stringify(value)));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: [styles.listItem, isFromScript ? styles.highlightedRow : undefined],
    gutterSize: "none",
    "data-test-subj": "listItem",
    onMouseEnter: () => setIsPinHovered(true),
    onMouseLeave: () => setIsPinHovered(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.keyAndValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.keyAndValueWrapper,
    "data-test-subj": "key",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }, renderName())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.keyAndValue,
    "data-test-subj": "value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }, renderValue()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.actions,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  }, toggleIsPinned && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: e => {
      const isKeyboardEvent = e.detail === 0; // Mouse = non-zero, Keyboard = 0
      toggleIsPinned(key, {
        isKeyboardEvent,
        buttonId: pinButtonId
      });
    },
    id: pinButtonId,
    onFocus: () => setIsPinFocused(true),
    onBlur: () => setIsPinFocused(false),
    color: "text",
    iconType: showPinIcon ? 'pinFilled' : 'empty',
    "data-test-subj": "pinFieldButton",
    "aria-label": _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.pinFieldButtonLabel', {
      defaultMessage: 'Pin field'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  }))), isPreviewImageModalVisible && /*#__PURE__*/_react.default.createElement(_image_preview_modal.ImagePreviewModal, {
    imgHTML: formattedValue,
    closeModal: () => setIsPreviewImageModalVisible(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  }));
};
exports.PreviewListItem = PreviewListItem;
const componentStyles = {
  listItem: ({
    euiTheme
  }) => (0, _react2.css)({
    borderBottom: euiTheme.border.thin,
    height: _constants.ITEM_HEIGHT,
    alignItems: 'center',
    overflow: 'hidden'
  }),
  highlightedRow: ({
    euiTheme
  }) => (0, _react2.css)({
    backgroundColor: euiTheme.colors.backgroundBasePrimary,
    fontWeight: euiTheme.font.weight.bold
  }),
  lightWeight: ({
    euiTheme
  }) => (0, _react2.css)({
    fontWeight: euiTheme.font.weight.regular
  }),
  keyAndValueWrapper: (0, _react2.css)({
    whiteSpace: 'nowrap',
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    display: 'block',
    width: '100%'
  }),
  keyAndValue: (0, _react2.css)({
    overflow: 'hidden',
    '& .euiToolTipAnchor': {
      width: '100%' // We need the tooltip <span /> to be 100% to display the text ellipsis of the field value
    }
  }),
  actions: ({
    euiTheme
  }) => (0, _react2.css)({
    flexBasis: `${euiTheme.size.l} !important`
  })
};