"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.refreshIntervalSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const refreshIntervalSchema = exports.refreshIntervalSchema = _configSchema.schema.object({
  pause: _configSchema.schema.boolean({
    meta: {
      description: 'Set to false to auto-refresh data on an interval.'
    }
  }),
  value: _configSchema.schema.number({
    meta: {
      description: 'A numeric value indicating refresh frequency in milliseconds.'
    }
  })
});