"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegacyFixedLayoutGlobalStyles = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _coreChromeLayoutConstants = require("@kbn/core-chrome-layout-constants");
var _global_app_styles = require("../common/global_app_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/layout/core-chrome-layout/layouts/legacy-fixed/legacy_fixed_global_app_style.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const globalLayoutStyles = euiTheme => (0, _react2.css)`
  :root {
    // height of the header banner
    --kbnHeaderBannerHeight: ${euiTheme.size.xl};
    // total height of all fixed headers (when the banner is *not* present) inherited from EUI
    --kbnHeaderOffset: var(--euiFixedHeadersOffset, 0px);
    // total height of everything when the banner is present
    --kbnHeaderOffsetWithBanner: calc(var(--kbnHeaderBannerHeight) + var(--kbnHeaderOffset));
    // height of the action menu in the header in serverless projects
    --kbnProjectHeaderAppActionMenuHeight: ${euiTheme.base * 3}px;
  }

  #kibana-body {
    // DO NOT ADD ANY OVERFLOW BEHAVIORS HERE
    // It will break the sticky navigation
    min-height: 100%;
    display: flex;
    flex-direction: column;
  }

  // Affixes a div to restrict the position of charts tooltip to the visible viewport minus the header
  #${_coreChromeLayoutConstants.APP_FIXED_VIEWPORT_ID} {
    pointer-events: none;
    visibility: hidden;
    position: fixed;
    top: var(--kbnAppHeadersOffset, var(--euiFixedHeadersOffset, 0));
    right: 0;
    bottom: 0;
    left: 0;
  }

  .kbnAppWrapper {
    // DO NOT ADD ANY OTHER STYLES TO THIS SELECTOR
    // This a very nested dependency happening in "all" apps
    display: flex;
    flex-flow: column nowrap;
    flex-grow: 1;
    z-index: 0; // This effectively puts every high z-index inside the scope of this wrapper to it doesn't interfere with the header and/or overlay mask
    position: relative; // This is temporary for apps that relied on this being present on \`.application\`
  }

  .kbnBody {
    padding-top: var(--euiFixedHeadersOffset, 0px);

    // total height of all fixed headers + the sticky action menu toolbar, dynamically updated depending on the presence of the elements
    --kbnAppHeadersOffset: var(--euiFixedHeadersOffset, 0px);

    // forward compatibility with new grid layout variables,
    // this current height of project header app action menu, 0 or the height of the top bar when it is present
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.topBar.height')}: 0px;

    // for forward compatibility with grid layout,
    // this variable can be used for sticky headers offset relative to the top of the application area
    --kbn-application--sticky-headers-offset: calc(
      var(--euiFixedHeadersOffset, 0px) + ${(0, _coreChromeLayoutConstants.layoutVar)('application.topBar.height', '0px')}
    );

    // for forward compatibility with grid layout,
    // --kbn-layout--application includes everything except chrome's fixed headers
    // for solution navigation, it also includes the top bar height (action menu)
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.top')}: var(--euiFixedHeadersOffset, 0px);
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.left')}: 0px;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.bottom')}: 0px;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.right')}: 0px;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.height')}: calc(100vh - ${(0, _coreChromeLayoutConstants.layoutVar)('application.top', '0px')});

    // --kbn-application--content also excludes the top bar height (action menu)
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.content.top')}: var(--kbnAppHeadersOffset, var(--euiFixedHeadersOffset, 0px));
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.content.left')}: 0px;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.content.bottom')}: 0px;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.content.right')}: 0px;
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.content.height')}: calc(100vh - ${(0, _coreChromeLayoutConstants.layoutVar)('application.content.top', '0px')});
  }

  // Conditionally override :root CSS fixed header variable. Updating \`--euiFixedHeadersOffset\`
  //on the body will cause all child EUI components to automatically update their offsets
  .kbnBody--hasHeaderBanner {
    --euiFixedHeadersOffset: var(--kbnHeaderOffsetWithBanner);

    // Offset fixed EuiHeaders by the top banner
    .euiHeader[data-fixed-header] {
      margin-top: var(--kbnHeaderBannerHeight);
    }

    // Prevent banners from covering full screen data grids
    .euiDataGrid--fullScreen {
      height: calc(100vh - var(--kbnHeaderBannerHeight));
      top: var(--kbnHeaderBannerHeight);
    }
  }

  // Set a body CSS variable for the app container to use - calculates the total
  // height of all fixed headers + the sticky action menu toolbar
  .kbnBody--hasProjectActionMenu {
    --kbnAppHeadersOffset: calc(
      var(--kbnHeaderOffset) + var(--kbnProjectHeaderAppActionMenuHeight)
    );

    &.kbnBody--hasHeaderBanner {
      --kbnAppHeadersOffset: calc(
        var(--kbnHeaderOffsetWithBanner) + var(--kbnProjectHeaderAppActionMenuHeight)
      );
    }

    // forward compatibility with new grid layout variables,
    ${(0, _coreChromeLayoutConstants.layoutVarName)('application.topBar.height')}: var(--kbnProjectHeaderAppActionMenuHeight);
  }

  .kbnBody--chromeHidden {
    // stylelint-disable-next-line length-zero-no-unit
    --euiFixedHeadersOffset: 0px;

    &.kbnBody--hasHeaderBanner {
      --euiFixedHeadersOffset: var(--kbnHeaderBannerHeight);
    }

    &.kbnBody--hasProjectActionMenu {
      --kbnAppHeadersOffset: var(--euiFixedHeadersOffset, 0);
    }
  }

  .euiDataGrid__restrictBody {
    .headerGlobalNav,
    .kbnQueryBar {
      display: none;
    }
  }

  .euiDataGrid__restrictBody.euiBody--headerIsFixed {
    .euiFlyout {
      top: 0;
      height: 100%;
    }
  }
`;
const LegacyFixedLayoutGlobalStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react2.Global, {
    styles: globalLayoutStyles(euiTheme),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_global_app_styles.CommonGlobalAppStyles, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }));
};
exports.LegacyFixedLayoutGlobalStyles = LegacyFixedLayoutGlobalStyles;