"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SideNavV2CollapseButton = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/core-chrome-navigation/src/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/ui/project/sidenav_v2/collapse_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sideNavCollapseButtonStyles = euiTheme => {
  // packages/eui/src/components/header/header.styles.ts
  const height = euiTheme.size.xxxl; // TODO: hardcoded height of the euiHeader header
  const padding = euiTheme.size.s; // TODO: hardcoded padding of the euiHeader header

  return {
    sideNavCollapseButtonWrapper: (0, _react.css)`
      display: flex;
      align-items: center;
      justify-content: center;
      ${(0, _eui.logicalSizeCSS)(height)}
      ${(0, _eui.logicalCSS)('border-right', euiTheme.border.thin)}
      ${(0, _eui.logicalCSS)('margin-left', `-${padding}`)}
      ${(0, _eui.logicalCSS)('margin-right', padding)}
    `,
    sideNavCollapseButton: (0, _react.css)`
      &.euiButtonIcon:hover {
        transform: none;
      }
    `
  };
};

/**
 * Reimplementation of EuiCollapsibleNavBeta Collapse Button to survey new sidenav and new layout use-cases
 */
const SideNavV2CollapseButton = ({
  isCollapsed,
  toggle,
  ...rest
}) => {
  const collapsedObservable = (0, _react2.useMemo)(() => (0, _rxjs.isObservable)(isCollapsed) ? isCollapsed : (0, _rxjs.of)(isCollapsed), [isCollapsed]);
  const collapsed = (0, _useObservable.default)(collapsedObservable, typeof isCollapsed === 'boolean' ? isCollapsed : false);
  const iconType = collapsed ? 'transitionLeftIn' : 'transitionLeftOut';
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = sideNavCollapseButtonStyles(euiTheme);
  const isSmall = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  if (isSmall) return null;
  return /*#__PURE__*/_react2.default.createElement("div", {
    className: "sideNavCollapseButtonWrapper",
    css: styles.sideNavCollapseButtonWrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "sideNavCollapseButton",
    css: styles.sideNavCollapseButton,
    size: "s",
    color: "text",
    iconType: iconType,
    "aria-label": collapsed ? _i18n.i18n.translate('core.ui.chrome.sideNavigation.expandButtonLabel', {
      defaultMessage: 'Expand navigation menu'
    }) : _i18n.i18n.translate('core.ui.chrome.sideNavigation.collapseButtonLabel', {
      defaultMessage: 'Collapse navigation menu'
    }),
    "aria-pressed": !collapsed,
    "aria-expanded": !collapsed,
    "aria-controls": _constants.PRIMARY_NAVIGATION_ID,
    onClick: () => toggle(!collapsed),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }));
};
exports.SideNavV2CollapseButton = SideNavV2CollapseButton;