"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerBundleRoutes = registerBundleRoutes;
var _repoInfo = require("@kbn/repo-info");
var _uiSharedDepsNpm = _interopRequireDefault(require("@kbn/ui-shared-deps-npm"));
var _uiSharedDepsSrc = require("@kbn/ui-shared-deps-src");
var KbnMonaco = _interopRequireWildcard(require("@kbn/monaco/server"));
var _file_hash_cache = require("./file_hash_cache");
var _bundles_route = require("./bundles_route");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 *  Creates the routes that serves files from `bundlesPath`.
 *
 *  @param {Object} options
 *  @property {Array<{id,path}>} options.npUiPluginPublicDirs array of ids and paths that should be served for new platform plugins
 *  @property {string} options.regularBundlesPath
 *  @property {string} options.basePublicPath
 *
 *  @return Array.of({Hapi.Route})
 */
function registerBundleRoutes({
  router,
  uiPlugins,
  packageInfo,
  staticAssets
}) {
  const {
    dist: isDist
  } = packageInfo;
  // rather than calculate the fileHash on every request, we
  // provide a cache object to `resolveDynamicAssetResponse()` that
  // will store the most recently used hashes.
  const fileHashCache = new _file_hash_cache.FileHashCache();
  const sharedNpmDepsPath = '/bundles/kbn-ui-shared-deps-npm/';
  (0, _bundles_route.registerRouteForBundle)(router, {
    publicPath: staticAssets.prependPublicUrl(sharedNpmDepsPath) + '/',
    routePath: staticAssets.prependServerPath(sharedNpmDepsPath) + '/',
    bundlesPath: _uiSharedDepsNpm.default.distDir,
    fileHashCache,
    isDist
  });
  const sharedDepsPath = '/bundles/kbn-ui-shared-deps-src/';
  (0, _bundles_route.registerRouteForBundle)(router, {
    publicPath: staticAssets.prependPublicUrl(sharedDepsPath) + '/',
    routePath: staticAssets.prependServerPath(sharedDepsPath) + '/',
    bundlesPath: _uiSharedDepsSrc.distDir,
    fileHashCache,
    isDist
  });
  const coreBundlePath = '/bundles/core/';
  (0, _bundles_route.registerRouteForBundle)(router, {
    publicPath: staticAssets.prependPublicUrl(coreBundlePath) + '/',
    routePath: staticAssets.prependServerPath(coreBundlePath) + '/',
    bundlesPath: isDist ? (0, _repoInfo.fromRoot)('node_modules/@kbn/core/target/public') : (0, _repoInfo.fromRoot)('src/core/target/public'),
    fileHashCache,
    isDist
  });
  const monacoEditorPath = '/bundles/kbn-monaco/';
  (0, _bundles_route.registerRouteForBundle)(router, {
    publicPath: staticAssets.prependPublicUrl(monacoEditorPath) + '/',
    routePath: staticAssets.prependServerPath(monacoEditorPath) + '/',
    bundlesPath: KbnMonaco.bundleDir,
    fileHashCache,
    isDist
  });
  [...uiPlugins.internal.entries()].forEach(([id, {
    publicTargetDir,
    version
  }]) => {
    const pluginBundlesPath = `/bundles/plugin/${id}/${version}/`;
    (0, _bundles_route.registerRouteForBundle)(router, {
      publicPath: staticAssets.prependPublicUrl(pluginBundlesPath) + '/',
      routePath: staticAssets.prependServerPath(pluginBundlesPath) + '/',
      bundlesPath: publicTargetDir,
      fileHashCache,
      isDist
    });
  });
}