"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateMaxTagsLength = exports.validateMaxLength = exports.validateEmptyTags = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isInvalidTag = value => value.trim() === '';
const isTagCharactersInLimit = (value, limit) => value.trim().length > limit;
const validateEmptyTags = ({
  value,
  message
}) => {
  if (!Array.isArray(value) && isInvalidTag(value) || Array.isArray(value) && value.length > 0 && value.find(item => isInvalidTag(item))) {
    return {
      message
    };
  }
};
exports.validateEmptyTags = validateEmptyTags;
const validateMaxLength = ({
  value,
  message,
  limit
}) => {
  if (!Array.isArray(value) && isTagCharactersInLimit(value, limit) || Array.isArray(value) && value.length > 0 && value.some(item => isTagCharactersInLimit(item, limit))) {
    return {
      message
    };
  }
};
exports.validateMaxLength = validateMaxLength;
const validateMaxTagsLength = ({
  value,
  message,
  limit
}) => {
  if (Array.isArray(value) && value.length > limit) {
    return {
      message
    };
  }
};
exports.validateMaxTagsLength = validateMaxTagsLength;