"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SidebarHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _tool_tip_shortcut = require("../tool_tip_shortcut");
var _shortcuts = require("../../../i18n/shortcuts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/sidebar_header/sidebar_header.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const strings = {
  getBringForwardAriaLabel: () => _i18n.i18n.translate('xpack.canvas.sidebarHeader.bringForwardArialLabel', {
    defaultMessage: 'Move element up one layer'
  }),
  getBringToFrontAriaLabel: () => _i18n.i18n.translate('xpack.canvas.sidebarHeader.bringToFrontArialLabel', {
    defaultMessage: 'Move element to top layer'
  }),
  getSendBackwardAriaLabel: () => _i18n.i18n.translate('xpack.canvas.sidebarHeader.sendBackwardArialLabel', {
    defaultMessage: 'Move element down one layer'
  }),
  getSendToBackAriaLabel: () => _i18n.i18n.translate('xpack.canvas.sidebarHeader.sendToBackArialLabel', {
    defaultMessage: 'Move element to bottom layer'
  })
};
const shortcutHelp = _shortcuts.ShortcutStrings.getShortcutHelp();
const SidebarHeader = ({
  title,
  showLayerControls = false,
  bringToFront,
  bringForward,
  sendBackward,
  sendToBack
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  className: "canvasLayout__sidebarHeader",
  gutterSize: "none",
  alignItems: "center",
  justifyContent: "spaceBetween",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 72,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 78,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 79,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement("h3", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 80,
    columnNumber: 9
  }
}, title))), showLayerControls ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 84,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 85,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 86,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "bottom",
  content: /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 17
    }
  }, shortcutHelp.BRING_TO_FRONT, /*#__PURE__*/_react.default.createElement(_tool_tip_shortcut.ToolTipShortcut, {
    namespace: "ELEMENT",
    action: "BRING_TO_FRONT",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 19
    }
  })),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 87,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  color: "text",
  iconType: "sortUp",
  onClick: bringToFront,
  "aria-label": strings.getBringToFrontAriaLabel(),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 96,
    columnNumber: 15
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 104,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "bottom",
  content: /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 17
    }
  }, shortcutHelp.BRING_FORWARD, /*#__PURE__*/_react.default.createElement(_tool_tip_shortcut.ToolTipShortcut, {
    namespace: "ELEMENT",
    action: "BRING_FORWARD",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 19
    }
  })),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 105,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  color: "text",
  iconType: "arrowUp",
  onClick: bringForward,
  "aria-label": strings.getBringForwardAriaLabel(),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 114,
    columnNumber: 15
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 122,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "bottom",
  content: /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 17
    }
  }, shortcutHelp.SEND_BACKWARD, /*#__PURE__*/_react.default.createElement(_tool_tip_shortcut.ToolTipShortcut, {
    namespace: "ELEMENT",
    action: "SEND_BACKWARD",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 19
    }
  })),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 123,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  color: "text",
  iconType: "arrowDown",
  onClick: sendBackward,
  "aria-label": strings.getSendBackwardAriaLabel(),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 132,
    columnNumber: 15
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 140,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "bottom",
  content: /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 17
    }
  }, shortcutHelp.SEND_TO_BACK, /*#__PURE__*/_react.default.createElement(_tool_tip_shortcut.ToolTipShortcut, {
    namespace: "ELEMENT",
    action: "SEND_TO_BACK",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 19
    }
  })),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 141,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  color: "text",
  iconType: "sortDown",
  onClick: sendToBack,
  "aria-label": strings.getSendToBackAriaLabel(),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 150,
    columnNumber: 15
  }
}))))) : null);
exports.SidebarHeader = SidebarHeader;