"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageControls = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/page_preview/page_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const strings = {
  getClonePageAriaLabel: () => _i18n.i18n.translate('xpack.canvas.pagePreviewPageControls.clonePageAriaLabel', {
    defaultMessage: 'Clone page'
  }),
  getClonePageTooltip: () => _i18n.i18n.translate('xpack.canvas.pagePreviewPageControls.clonePageTooltip', {
    defaultMessage: 'Clone'
  }),
  getDeletePageAriaLabel: () => _i18n.i18n.translate('xpack.canvas.pagePreviewPageControls.deletePageAriaLabel', {
    defaultMessage: 'Delete page'
  }),
  getDeletePageTooltip: () => _i18n.i18n.translate('xpack.canvas.pagePreviewPageControls.deletePageTooltip', {
    defaultMessage: 'Delete'
  })
};
const PageControls = ({
  pageId,
  onRemove,
  onDuplicate
}) => {
  const handleDuplicate = ev => {
    ev.preventDefault();
    onDuplicate(pageId);
  };
  const handleRemove = ev => {
    ev.preventDefault();
    onRemove(pageId);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "canvasPageManager__controls",
    gutterSize: "xs",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: strings.getClonePageTooltip(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "copy",
    "aria-label": strings.getClonePageAriaLabel(),
    onClick: handleDuplicate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: strings.getDeletePageTooltip(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    iconType: "trash",
    "aria-label": strings.getDeletePageAriaLabel(),
    onClick: handleRemove,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }))));
};
exports.PageControls = PageControls;
PageControls.propTypes = {
  pageId: _propTypes.default.string.isRequired,
  onRemove: _propTypes.default.func.isRequired,
  onDuplicate: _propTypes.default.func.isRequired
};