"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decoratePackagePolicyWithAgentConfigAndSourceMap = decoratePackagePolicyWithAgentConfigAndSourceMap;
var _list_configurations = require("../settings/agent_configuration/list_configurations");
var _get_package_policy_decorators = require("./get_package_policy_decorators");
var _source_maps = require("./source_maps");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function decoratePackagePolicyWithAgentConfigAndSourceMap({
  packagePolicy,
  internalESClient,
  fleetPluginStart,
  apmIndices
}) {
  const [agentConfigurations, {
    artifacts
  }] = await Promise.all([(0, _list_configurations.listConfigurations)({
    internalESClient,
    apmIndices
  }), (0, _source_maps.listSourceMapArtifacts)({
    fleetPluginStart
  })]);
  const policyWithSourceMaps = (0, _get_package_policy_decorators.getPackagePolicyWithSourceMap)({
    packagePolicy,
    artifacts
  });
  const policyWithAgentConfigAndSourceMaps = (0, _get_package_policy_decorators.getPackagePolicyWithAgentConfigurations)(policyWithSourceMaps, agentConfigurations);
  return policyWithAgentConfigAndSourceMaps;
}