"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependenciesTable = DependenciesTable;
exports.INITIAL_SORTING_FIELD = exports.INITIAL_SORTING_DIRECTION = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_breakpoints = require("../../../hooks/use_breakpoints");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _empty_message = require("../empty_message");
var _managed_table = require("../managed_table");
var _overview_table_container = require("../overview_table_container");
var _truncate_with_tooltip = require("../truncate_with_tooltip");
var _get_span_metric_columns = require("./get_span_metric_columns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/dependencies_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INITIAL_SORTING_FIELD = exports.INITIAL_SORTING_FIELD = 'impact';
const INITIAL_SORTING_DIRECTION = exports.INITIAL_SORTING_DIRECTION = 'desc';
function DependenciesTable({
  dependencies,
  fixedHeight,
  link,
  title,
  nameColumnTitle,
  status,
  compact = true,
  showPerPageOptions = true,
  initialPageSize,
  showSparkPlots,
  onChangeRenderedItems,
  saveTableOptionsToUrl = true
}) {
  const {
    isLarge
  } = (0, _use_breakpoints.useBreakpoints)();
  const shouldShowSparkPlots = showSparkPlots !== null && showSparkPlots !== void 0 ? showSparkPlots : !isLarge;
  const items = (0, _react.useMemo)(() => dependencies.map(dependency => ({
    name: dependency.name,
    link: dependency.link,
    latency: dependency.currentStats.latency.value,
    throughput: dependency.currentStats.throughput.value,
    failureRate: dependency.currentStats.errorRate.value,
    impact: dependency.currentStats.impact,
    currentStats: {
      latency: dependency.currentStats.latency.timeseries,
      throughput: dependency.currentStats.throughput.timeseries,
      failureRate: dependency.currentStats.errorRate.timeseries
    },
    previousStats: dependency.previousStats ? {
      latency: dependency.previousStats.latency.timeseries,
      throughput: dependency.previousStats.throughput.timeseries,
      failureRate: dependency.previousStats.errorRate.timeseries,
      impact: dependency.previousStats.impact
    } : undefined
  })), [dependencies]);
  const columns = [{
    field: 'name',
    name: nameColumnTitle,
    render: (_, item) => {
      const {
        name,
        link: itemLink
      } = item;
      return /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
        text: name,
        content: itemLink,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 16
        }
      });
    },
    sortable: true,
    width: '30%'
  }, ...(0, _get_span_metric_columns.getSpanMetricColumns)({
    shouldShowSparkPlots,
    comparisonFetchStatus: status
  })];
  const noItemsMessage = !compact ? /*#__PURE__*/_react.default.createElement(_empty_message.EmptyMessage, {
    heading: _i18n.i18n.translate('xpack.apm.dependenciesTable.notFoundLabel', {
      defaultMessage: 'No dependencies found'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  }) : _i18n.i18n.translate('xpack.apm.dependenciesTable.notFoundLabel', {
    defaultMessage: 'No dependencies found'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "dependenciesTable",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 15
    }
  }, title))), link && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 20
    }
  }, link))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_table_container.OverviewTableContainer, {
    fixedHeight: fixedHeight,
    isEmptyAndNotInitiated: items.length === 0 && status === _use_fetcher.FETCH_STATUS.NOT_INITIATED,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    isLoading: status === _use_fetcher.FETCH_STATUS.LOADING,
    error: status === _use_fetcher.FETCH_STATUS.FAILURE,
    columns: columns,
    items: items,
    noItemsMessage: noItemsMessage,
    initialSortField: INITIAL_SORTING_FIELD,
    initialSortDirection: INITIAL_SORTING_DIRECTION,
    pagination: true,
    showPerPageOptions: showPerPageOptions,
    initialPageSize: initialPageSize,
    onChangeRenderedItems: onChangeRenderedItems,
    saveTableOptionsToUrl: saveTableOptionsToUrl,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }))));
}