"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddApmData = AddApmData;
exports.AssociateServiceLogs = AssociateServiceLogs;
exports.CollectServiceLogs = CollectServiceLogs;
exports.collectServiceLogsProps = exports.associateServiceLogsProps = exports.addApmDataProps = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/add_data_buttons/buttons.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Disabling it for now until the EUI team fixes it
/* eslint-disable @elastic/eui/href-or-on-click */
const addApmDataProps = locator => {
  return {
    name: _i18n.i18n.translate('xpack.apm.add.apm.agent.button.', {
      defaultMessage: 'Add APM'
    }),
    link: locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl({
      category: 'application'
    })
  };
};
exports.addApmDataProps = addApmDataProps;
const associateServiceLogsProps = exports.associateServiceLogsProps = {
  name: _i18n.i18n.translate('xpack.apm.associate.service.logs.button', {
    defaultMessage: 'Associate existing service logs'
  }),
  link: 'https://ela.st/new-experience-associate-service-logs'
};
const collectServiceLogsProps = locator => {
  var _locator$getRedirectU;
  return {
    name: _i18n.i18n.translate('xpack.apm.collect.service.logs.button', {
      defaultMessage: 'Collect new service logs'
    }),
    link: (_locator$getRedirectU = locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl({
      source: 'auto-detect'
    })) !== null && _locator$getRedirectU !== void 0 ? _locator$getRedirectU : ''
  };
};
exports.collectServiceLogsProps = collectServiceLogsProps;
function AddApmData({
  fill = false,
  size = 's',
  ...props
}) {
  const {
    share: {
      url: {
        locators
      }
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const onboardingLocator = locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  const addApmDataButtonProps = addApmDataProps(onboardingLocator);
  if (!addApmDataButtonProps.link) {
    return;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": props['data-test-subj'],
    size: size,
    onClick: props.onClick,
    href: addApmDataButtonProps === null || addApmDataButtonProps === void 0 ? void 0 : addApmDataButtonProps.link,
    fill: fill,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, addApmDataButtonProps.name);
}
function AssociateServiceLogs({
  onClick
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "associateServiceLogsPropsButton",
    size: "s",
    onClick: onClick,
    href: associateServiceLogsProps.link,
    target: "_blank",
    iconType: "popout",
    iconSide: "right",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, associateServiceLogsProps.name);
}
function CollectServiceLogs({
  onClick
}) {
  const {
    share: {
      url: {
        locators
      }
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const onboardingLocator = locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    basePath
  } = core.http;
  const {
    name,
    link
  } = collectServiceLogsProps(onboardingLocator);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "collectServiceLogsPropsButton",
    size: "s",
    onClick: onClick,
    href: basePath.prepend(link),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, name);
}