"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingHostsCallout = ProfilingHostsCallout;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_local_storage = require("../../../hooks/use_local_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/profiling_overview/profiling_hosts_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ProfilingHostsCallout({
  serviceName
}) {
  var _services$docLinks;
  const {
    services
  } = (0, _public.useKibana)();
  const baseUrl = ((_services$docLinks = services.docLinks) === null || _services$docLinks === void 0 ? void 0 : _services$docLinks.ELASTIC_WEBSITE_URL) || 'https://www.elastic.co/';
  const [apmUniversalProfilingShowCallout, setAPMUniversalProfilingShowCallout] = (0, _use_local_storage.useLocalStorage)('apmUniversalProfilingShowCallout', true);
  if (apmUniversalProfilingShowCallout === false) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.profiling.callout.title', {
      defaultMessage: 'Displaying profiling insights from the host(s) running {serviceName} services',
      values: {
        serviceName
      }
    }),
    color: "primary",
    iconType: "info",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.apm.profiling.callout.description', {
    defaultMessage: 'Universal Profiling provides unprecedented code visibility into the runtime behaviour of all applications. It profiles every line of code on the host(s) running your services, including not only your application code but also the kernel and third-party libraries.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      justifyContent: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: `${baseUrl}observability/universal-profiling`,
    target: "_blank",
    "data-test-subj": "apmProfilingOverviewLearnMoreLink",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.profiling.callout.learnMore', {
    defaultMessage: 'Learn more'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmProfilingOverviewLinkButtonButton",
    color: "primary",
    onClick: () => setAPMUniversalProfilingShowCallout(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.profiling.callout.dismiss', {
    defaultMessage: 'Dismiss'
  })))));
}