"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.maintenanceWindowSchema = exports.maintenanceWindowEventSchema = exports.maintenanceWindowCategoryIdsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../constants");
var _schemas = require("../../r_rule/schemas");
var _schemas2 = require("../../alerts_filter_query/schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maintenanceWindowEventSchema = exports.maintenanceWindowEventSchema = _configSchema.schema.object({
  gte: _configSchema.schema.string(),
  lte: _configSchema.schema.string()
});
const maintenanceWindowCategoryIdsSchema = exports.maintenanceWindowCategoryIdsSchema = _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(_constants.maintenanceWindowCategoryIdTypes.OBSERVABILITY), _configSchema.schema.literal(_constants.maintenanceWindowCategoryIdTypes.SECURITY_SOLUTION), _configSchema.schema.literal(_constants.maintenanceWindowCategoryIdTypes.MANAGEMENT)]))));
const maintenanceWindowSchema = exports.maintenanceWindowSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  title: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  duration: _configSchema.schema.number(),
  expirationDate: _configSchema.schema.string(),
  events: _configSchema.schema.arrayOf(maintenanceWindowEventSchema),
  rRule: _schemas.rRuleSchema,
  createdBy: _configSchema.schema.nullable(_configSchema.schema.string()),
  updatedBy: _configSchema.schema.nullable(_configSchema.schema.string()),
  createdAt: _configSchema.schema.string(),
  updatedAt: _configSchema.schema.string(),
  eventStartTime: _configSchema.schema.nullable(_configSchema.schema.string()),
  eventEndTime: _configSchema.schema.nullable(_configSchema.schema.string()),
  status: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.maintenanceWindowStatus.RUNNING), _configSchema.schema.literal(_constants.maintenanceWindowStatus.UPCOMING), _configSchema.schema.literal(_constants.maintenanceWindowStatus.FINISHED), _configSchema.schema.literal(_constants.maintenanceWindowStatus.ARCHIVED), _configSchema.schema.literal(_constants.maintenanceWindowStatus.DISABLED)]),
  categoryIds: maintenanceWindowCategoryIdsSchema,
  scopedQuery: _configSchema.schema.maybe(_configSchema.schema.nullable(_schemas2.alertsFilterQuerySchema))
});