"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentCountChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _aiopsComponents = require("@kbn/aiops-components");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _total_count_header = require("../document_count_content/total_count_header");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_categorization/document_count_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DocumentCountChart = ({
  eventRate,
  totalCount,
  pinnedCategory,
  selectedCategory,
  documentCountStats
}) => {
  const {
    data,
    uiSettings,
    fieldFormats,
    charts
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const chartPointsSplitLabel = _i18n.i18n.translate('xpack.aiops.logCategorization.chartPointsSplitLabel', {
    defaultMessage: 'Selected pattern'
  });
  const chartPoints = (0, _react.useMemo)(() => {
    var _ref;
    const category = (_ref = selectedCategory !== null && selectedCategory !== void 0 ? selectedCategory : pinnedCategory) !== null && _ref !== void 0 ? _ref : null;
    return eventRate.map(({
      key,
      docCount
    }) => {
      let value = docCount;
      if (category && category.sparkline && category.sparkline[key]) {
        const val = category.sparkline[key];
        value = val > docCount ? 0 : docCount - val;
      }
      return {
        time: key,
        value
      };
    });
  }, [eventRate, pinnedCategory, selectedCategory]);
  const chartPointsSplit = (0, _react.useMemo)(() => {
    var _ref2;
    const category = (_ref2 = selectedCategory !== null && selectedCategory !== void 0 ? selectedCategory : pinnedCategory) !== null && _ref2 !== void 0 ? _ref2 : null;
    return category !== null ? eventRate.map(({
      key,
      docCount
    }) => {
      const val = category.sparkline && category.sparkline[key] ? category.sparkline[key] : 0;
      const value = val > docCount ? docCount : val;
      return {
        time: key,
        value
      };
    }) : undefined;
  }, [eventRate, pinnedCategory, selectedCategory]);
  if ((documentCountStats === null || documentCountStats === void 0 ? void 0 : documentCountStats.interval) === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_total_count_header.TotalCountHeader, {
    totalCount: totalCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_aiopsComponents.DocumentCountChart, {
    dependencies: {
      data,
      uiSettings,
      fieldFormats,
      charts
    },
    chartPoints: chartPoints,
    chartPointsSplit: chartPointsSplit,
    timeRangeEarliest: eventRate[0].key,
    timeRangeLatest: eventRate[eventRate.length - 1].key,
    interval: documentCountStats.interval,
    chartPointsSplitLabel: chartPointsSplitLabel,
    isBrushCleared: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }));
};
exports.DocumentCountChart = DocumentCountChart;