/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.mvdedupe;

import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.operator.mvdedupe.BatchEncoder;

public class MultivalueDedupeBoolean {
    public static final int NULL_ORD = 0;
    public static final int FALSE_ORD = 1;
    public static final int TRUE_ORD = 2;
    private final BooleanBlock block;
    private boolean seenTrue;
    private boolean seenFalse;

    public MultivalueDedupeBoolean(BooleanBlock block) {
        this.block = block;
    }

    public BooleanBlock dedupeToBlock(BlockFactory blockFactory) {
        if (this.block.mvDeduplicated()) {
            this.block.incRef();
            return this.block;
        }
        try (BooleanBlock.Builder builder = blockFactory.newBooleanBlockBuilder(this.block.getPositionCount());){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        builder.appendBoolean(this.block.getBoolean(first));
                        continue block9;
                    }
                    default: {
                        this.readValues(first, count);
                        this.writeValues(builder);
                    }
                }
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    public BooleanBlock sortToBlock(BlockFactory blockFactory, boolean ascending) {
        try (BooleanBlock.Builder builder = blockFactory.newBooleanBlockBuilder(this.block.getPositionCount());){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int totalCount = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (totalCount) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        builder.appendBoolean(this.block.getBoolean(first));
                        continue block9;
                    }
                    default: {
                        int trueCount = this.countTrue(first, totalCount);
                        builder.beginPositionEntry();
                        if (ascending) {
                            this.writeValues(builder, false, 1, totalCount - trueCount);
                            this.writeValues(builder, true, totalCount - trueCount + 1, totalCount);
                        } else {
                            this.writeValues(builder, true, 1, trueCount);
                            this.writeValues(builder, false, trueCount + 1, totalCount);
                        }
                        builder.endPositionEntry();
                    }
                }
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    public IntBlock hash(BlockFactory blockFactory, boolean[] everSeen) {
        try (IntBlock.Builder builder = blockFactory.newIntBlockBuilder(this.block.getPositionCount());){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        everSeen[0] = true;
                        builder.appendInt(0);
                        continue block9;
                    }
                    case 1: {
                        builder.appendInt(MultivalueDedupeBoolean.hashOrd(everSeen, this.block.getBoolean(first)));
                        continue block9;
                    }
                    default: {
                        this.readValues(first, count);
                        this.hashValues(everSeen, builder);
                    }
                }
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    public BatchEncoder batchEncoder(int batchSize) {
        this.block.incRef();
        return new BatchEncoder.Booleans(Math.max(2, batchSize)){

            @Override
            protected void readNextBatch() {
                block4: for (int position = this.firstPosition(); position < MultivalueDedupeBoolean.this.block.getPositionCount(); ++position) {
                    if (!this.hasCapacity(2)) {
                        return;
                    }
                    int count = MultivalueDedupeBoolean.this.block.getValueCount(position);
                    int first = MultivalueDedupeBoolean.this.block.getFirstValueIndex(position);
                    switch (count) {
                        case 0: {
                            this.encodeNull();
                            continue block4;
                        }
                        case 1: {
                            boolean v = MultivalueDedupeBoolean.this.block.getBoolean(first);
                            this.startPosition();
                            this.encode(v);
                            this.endPosition();
                            continue block4;
                        }
                        default: {
                            MultivalueDedupeBoolean.this.readValues(first, count);
                            this.startPosition();
                            MultivalueDedupeBoolean.this.encodeUniquedWork(this);
                            this.endPosition();
                        }
                    }
                }
            }

            public void close() {
                MultivalueDedupeBoolean.this.block.decRef();
            }
        };
    }

    private void readValues(int first, int count) {
        int end = first + count;
        this.seenFalse = false;
        this.seenTrue = false;
        for (int i = first; i < end; ++i) {
            if (this.block.getBoolean(i)) {
                this.seenTrue = true;
                if (!this.seenFalse) continue;
                break;
            }
            this.seenFalse = true;
            if (this.seenTrue) break;
        }
    }

    private void writeValues(BooleanBlock.Builder builder) {
        if (this.seenFalse) {
            if (this.seenTrue) {
                builder.beginPositionEntry();
                builder.appendBoolean(false);
                builder.appendBoolean(true);
                builder.endPositionEntry();
            } else {
                builder.appendBoolean(false);
            }
        } else if (this.seenTrue) {
            builder.appendBoolean(true);
        } else {
            throw new IllegalStateException("didn't see true of false but counted values");
        }
    }

    private void hashValues(boolean[] everSeen, IntBlock.Builder builder) {
        if (this.seenFalse) {
            if (this.seenTrue) {
                builder.beginPositionEntry();
                builder.appendInt(MultivalueDedupeBoolean.hashOrd(everSeen, false));
                builder.appendInt(MultivalueDedupeBoolean.hashOrd(everSeen, true));
                builder.endPositionEntry();
            } else {
                builder.appendInt(MultivalueDedupeBoolean.hashOrd(everSeen, false));
            }
        } else if (this.seenTrue) {
            builder.appendInt(MultivalueDedupeBoolean.hashOrd(everSeen, true));
        } else {
            throw new IllegalStateException("didn't see true of false but counted values");
        }
    }

    private void encodeUniquedWork(BatchEncoder.Booleans encoder) {
        if (this.seenFalse) {
            encoder.encode(false);
        }
        if (this.seenTrue) {
            encoder.encode(true);
        }
    }

    public static int hashOrd(boolean[] everSeen, boolean b) {
        if (b) {
            everSeen[2] = true;
            return 2;
        }
        everSeen[1] = true;
        return 1;
    }

    private int countTrue(int first, int count) {
        int trueCount = 0;
        int end = first + count;
        for (int i = first; i < end; ++i) {
            if (!this.block.getBoolean(i)) continue;
            ++trueCount;
        }
        return trueCount;
    }

    private void writeValues(BooleanBlock.Builder builder, boolean value, int startIndex, int endIndex) {
        for (int i = startIndex; i <= endIndex; ++i) {
            builder.appendBoolean(value);
        }
    }
}

