/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene.read;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.read.ValuesFromManyReader;
import org.elasticsearch.compute.lucene.read.ValuesFromSingleReader;
import org.elasticsearch.compute.lucene.read.ValuesSourceReaderOperatorStatus;
import org.elasticsearch.compute.operator.AbstractPageMappingToIteratorOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.search.fetch.StoredFieldsSpec;

public class ValuesSourceReaderOperator
extends AbstractPageMappingToIteratorOperator {
    final BlockFactory blockFactory;
    final long jumboBytes;
    final FieldWork[] fields;
    final List<ShardContext> shardContexts;
    private final int docChannel;
    private final Map<String, Integer> readersBuilt = new TreeMap<String, Integer>();
    long valuesLoaded;
    private int lastShard = -1;
    private int lastSegment = -1;

    public ValuesSourceReaderOperator(BlockFactory blockFactory, long jumboBytes, List<FieldInfo> fields, List<ShardContext> shardContexts, int docChannel) {
        if (fields.isEmpty()) {
            throw new IllegalStateException("ValuesSourceReaderOperator doesn't support empty fields");
        }
        this.blockFactory = blockFactory;
        this.jumboBytes = jumboBytes;
        this.fields = (FieldWork[])fields.stream().map(x$0 -> new FieldWork((FieldInfo)x$0)).toArray(FieldWork[]::new);
        this.shardContexts = shardContexts;
        this.docChannel = docChannel;
    }

    @Override
    protected ReleasableIterator<Page> receive(Page page) {
        DocVector docVector = ((DocBlock)page.getBlock(this.docChannel)).asVector();
        return ValuesSourceReaderOperator.appendBlockArrays(page, docVector.singleSegment() ? new ValuesFromSingleReader(this, docVector) : new ValuesFromManyReader(this, docVector));
    }

    void positionFieldWork(int shard, int segment, int firstDoc) {
        if (this.lastShard == shard) {
            if (this.lastSegment == segment) {
                for (FieldWork w : this.fields) {
                    w.sameSegment(firstDoc);
                }
                return;
            }
            this.lastSegment = segment;
            for (FieldWork w : this.fields) {
                w.sameShardNewSegment();
            }
            return;
        }
        this.lastShard = shard;
        this.lastSegment = segment;
        for (FieldWork w : this.fields) {
            w.newShard(shard);
        }
    }

    boolean positionFieldWorkDocGuaranteedAscending(int shard, int segment) {
        if (this.lastShard == shard) {
            if (this.lastSegment == segment) {
                return false;
            }
            this.lastSegment = segment;
            for (FieldWork w : this.fields) {
                w.sameShardNewSegment();
            }
            return true;
        }
        this.lastShard = shard;
        this.lastSegment = segment;
        for (FieldWork w : this.fields) {
            w.newShard(shard);
        }
        return true;
    }

    void trackStoredFields(StoredFieldsSpec spec, boolean sequential) {
        this.readersBuilt.merge("stored_fields[requires_source:" + spec.requiresSource() + ", fields:" + spec.requiredStoredFields().size() + ", sequential: " + sequential + "]", 1, (prev, one) -> prev + one);
    }

    LeafReaderContext ctx(int shard, int segment) {
        return (LeafReaderContext)this.shardContexts.get(shard).reader().leaves().get(segment);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValuesSourceReaderOperator[fields = [");
        if (this.fields.length < 10) {
            boolean first = true;
            for (FieldWork f : this.fields) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(f.info.name);
            }
        } else {
            sb.append(this.fields.length).append(" fields");
        }
        return sb.append("]]").toString();
    }

    @Override
    protected ValuesSourceReaderOperatorStatus status(long processNanos, int pagesReceived, int pagesEmitted, long rowsReceived, long rowsEmitted) {
        return new ValuesSourceReaderOperatorStatus(new TreeMap<String, Integer>(this.readersBuilt), processNanos, pagesReceived, pagesEmitted, rowsReceived, rowsEmitted, this.valuesLoaded);
    }

    void sanityCheckBlock(Object loader, int expectedPositions, Block block, int field) {
        if (block.getPositionCount() != expectedPositions) {
            throw new IllegalStateException(this.sanityCheckBlockErrorPrefix(loader, block, field) + " has [" + block.getPositionCount() + "] positions instead of [" + expectedPositions + "]");
        }
        if (block.elementType() != ElementType.NULL && block.elementType() != this.fields[field].info.type) {
            throw new IllegalStateException(this.sanityCheckBlockErrorPrefix(loader, block, field) + "'s element_type [" + String.valueOf((Object)block.elementType()) + "] NOT IN (NULL, " + String.valueOf((Object)this.fields[field].info.type) + ")");
        }
    }

    private String sanityCheckBlockErrorPrefix(Object loader, Block block, int field) {
        return this.fields[field].info.name + "[" + String.valueOf(loader) + "]: " + String.valueOf(block);
    }

    protected class FieldWork {
        final FieldInfo info;
        BlockLoader loader;
        BlockLoader.ColumnAtATimeReader columnAtATime;
        BlockLoader.RowStrideReader rowStride;

        FieldWork(FieldInfo info) {
            this.info = info;
        }

        void sameSegment(int firstDoc) {
            if (this.columnAtATime != null && !this.columnAtATime.canReuse(firstDoc)) {
                this.columnAtATime = null;
            }
            if (this.rowStride != null && !this.rowStride.canReuse(firstDoc)) {
                this.rowStride = null;
            }
        }

        void sameShardNewSegment() {
            this.columnAtATime = null;
            this.rowStride = null;
        }

        void newShard(int shard) {
            this.loader = this.info.blockLoader.apply(shard);
            this.columnAtATime = null;
            this.rowStride = null;
        }

        BlockLoader.ColumnAtATimeReader columnAtATime(LeafReaderContext ctx) throws IOException {
            if (this.columnAtATime == null) {
                this.columnAtATime = this.loader.columnAtATimeReader(ctx);
                this.trackReader("column_at_a_time", (BlockLoader.Reader)this.columnAtATime);
            }
            return this.columnAtATime;
        }

        BlockLoader.RowStrideReader rowStride(LeafReaderContext ctx) throws IOException {
            if (this.rowStride == null) {
                this.rowStride = this.loader.rowStrideReader(ctx);
                this.trackReader("row_stride", (BlockLoader.Reader)this.rowStride);
            }
            return this.rowStride;
        }

        private void trackReader(String type, BlockLoader.Reader reader) {
            ValuesSourceReaderOperator.this.readersBuilt.merge(this.info.name + ":" + type + ":" + String.valueOf(reader), 1, (prev, one) -> prev + one);
        }
    }

    public record ShardContext(IndexReader reader, Supplier<SourceLoader> newSourceLoader, double storedFieldsSequentialProportion) {
    }

    public record FieldInfo(String name, ElementType type, boolean nullsFiltered, IntFunction<BlockLoader> blockLoader) {
    }

    public record Factory(ByteSizeValue jumboSize, List<FieldInfo> fields, List<ShardContext> shardContexts, int docChannel) implements Operator.OperatorFactory
    {
        public Factory {
            if (fields.isEmpty()) {
                throw new IllegalStateException("ValuesSourceReaderOperator doesn't support empty fields");
            }
        }

        @Override
        public Operator get(DriverContext driverContext) {
            return new ValuesSourceReaderOperator(driverContext.blockFactory(), this.jumboSize.getBytes(), this.fields, this.shardContexts, this.docChannel);
        }

        @Override
        public String describe() {
            StringBuilder sb = new StringBuilder();
            sb.append("ValuesSourceReaderOperator[fields = [");
            if (this.fields.size() < 10) {
                boolean first = true;
                for (FieldInfo f : this.fields) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(f.name);
                }
            } else {
                sb.append(this.fields.size()).append(" fields");
            }
            return sb.append("]]").toString();
        }
    }
}

