/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias.get;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;

public class TransportGetAliasesAction
extends TransportLocalProjectMetadataAction<GetAliasesRequest, GetAliasesResponse> {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(TransportGetAliasesAction.class);
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final SystemIndices systemIndices;
    private final ThreadContext threadContext;

    @Inject
    public TransportGetAliasesAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices) {
        super("indices:admin/aliases/get", actionFilters, transportService.getTaskManager(), clusterService, clusterService.threadPool().executor("management"), projectResolver);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.systemIndices = systemIndices;
        this.threadContext = clusterService.threadPool().getThreadContext();
    }

    @Override
    protected ClusterBlockException checkBlock(GetAliasesRequest request, ProjectState state) {
        return state.blocks().indicesBlockedException(state.projectId(), ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNamesWithSystemIndexAccess(state.metadata(), (IndicesRequest)request));
    }

    @Override
    protected void localClusterStateOperation(Task task, GetAliasesRequest request, ProjectState state, ActionListener<GetAliasesResponse> listener) {
        assert (Transports.assertNotTransportThread("no need to avoid the context switch and may be expensive if there are many aliases"));
        CancellableTask cancellableTask = (CancellableTask)task;
        ProjectMetadata projectMetadata = state.metadata();
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNamesWithSystemIndexAccess(projectMetadata, (IndicesRequest)request);
        SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel = this.indexNameExpressionResolver.getSystemIndexAccessLevel();
        Map<String, List<AliasMetadata>> aliases = projectMetadata.findAliases(request.aliases(), concreteIndices);
        cancellableTask.ensureNotCancelled();
        listener.onResponse(new GetAliasesResponse(TransportGetAliasesAction.postProcess(request, concreteIndices, aliases, projectMetadata, systemIndexAccessLevel, this.threadContext, this.systemIndices), TransportGetAliasesAction.postProcess(this.indexNameExpressionResolver, request, projectMetadata)));
    }

    static Map<String, List<AliasMetadata>> postProcess(GetAliasesRequest request, String[] concreteIndices, Map<String, List<AliasMetadata>> aliases, ProjectMetadata projectMetadata, SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel, ThreadContext threadContext, SystemIndices systemIndices) {
        boolean noAliasesSpecified = request.getOriginalAliases() == null || request.getOriginalAliases().length == 0;
        HashMap<String, List<AliasMetadata>> mapBuilder = new HashMap<String, List<AliasMetadata>>(aliases);
        for (String index : concreteIndices) {
            IndexAbstraction ia = (IndexAbstraction)projectMetadata.getIndicesLookup().get(index);
            assert (ia.getType() == IndexAbstraction.Type.CONCRETE_INDEX);
            if (ia.getParentDataStream() != null || aliases.get(index) != null || !noAliasesSpecified) continue;
            List previous = mapBuilder.put(index, Collections.emptyList());
            assert (previous == null);
        }
        Map<String, List<AliasMetadata>> finalResponse = Collections.unmodifiableMap(mapBuilder);
        if (systemIndexAccessLevel != SystemIndices.SystemIndexAccessLevel.ALL) {
            TransportGetAliasesAction.checkSystemIndexAccess(systemIndices, projectMetadata, finalResponse, systemIndexAccessLevel, threadContext);
        }
        return finalResponse;
    }

    static Map<String, List<DataStreamAlias>> postProcess(IndexNameExpressionResolver resolver, GetAliasesRequest request, ProjectMetadata projectMetadata) {
        HashMap result = new HashMap();
        List<String> requestedDataStreams = resolver.dataStreamNames(projectMetadata, request.indicesOptions(), request.indices());
        return projectMetadata.findDataStreamAliases(request.aliases(), requestedDataStreams.toArray(new String[0]));
    }

    private static void checkSystemIndexAccess(SystemIndices systemIndices, ProjectMetadata projectMetadata, Map<String, List<AliasMetadata>> aliasesMap, SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel, ThreadContext threadContext) {
        Predicate<String> systemIndexAccessAllowPredicate;
        if (systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.NONE) {
            systemIndexAccessAllowPredicate = Predicates.never();
        } else if (systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.RESTRICTED) {
            systemIndexAccessAllowPredicate = systemIndices.getProductSystemIndexNamePredicate(threadContext);
        } else {
            throw new IllegalArgumentException("Unexpected system index access level: " + String.valueOf((Object)systemIndexAccessLevel));
        }
        ArrayList<String> netNewSystemIndices = new ArrayList<String>();
        ArrayList systemIndicesNames = new ArrayList();
        aliasesMap.keySet().forEach(indexName -> {
            IndexMetadata index = projectMetadata.index((String)indexName);
            if (index != null && index.isSystem() && !systemIndexAccessAllowPredicate.test((String)indexName)) {
                if (systemIndices.isNetNewSystemIndex((String)indexName)) {
                    netNewSystemIndices.add((String)indexName);
                } else {
                    systemIndicesNames.add(indexName);
                }
            }
        });
        if (!systemIndicesNames.isEmpty()) {
            deprecationLogger.warn(DeprecationCategory.API, "open_system_index_access", "this request accesses system indices: {}, but in a future major version, direct access to system indices will be prevented by default", systemIndicesNames);
        }
        if (!netNewSystemIndices.isEmpty()) {
            throw SystemIndices.netNewSystemIndexAccessException(threadContext, netNewSystemIndices);
        }
    }
}

