/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.session;

import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;

public class EsqlLicenseChecker {
    public static final LicensedFeature.Momentary CCS_FEATURE = LicensedFeature.momentary(null, (String)"esql-ccs", (License.OperationMode)License.OperationMode.ENTERPRISE);

    public static boolean isCcsAllowed(XPackLicenseState licenseState) {
        if (licenseState == null) {
            return false;
        }
        return CCS_FEATURE.check(licenseState);
    }

    public static ElasticsearchStatusException invalidLicenseForCcsException(XPackLicenseState licenseState) {
        Object message = "A valid Enterprise license is required to run ES|QL cross-cluster searches. License found: ";
        message = licenseState == null ? (String)message + "none" : (String)message + licenseState.statusDescription();
        return new ElasticsearchStatusException((String)message, RestStatus.BAD_REQUEST, new Object[0]);
    }
}

