/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.node.MockNode;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.MockHttpTransport;
import org.elasticsearch.test.TestCluster;
import org.elasticsearch.transport.TransportSettings;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@Deprecated(forRemoval=true)
public final class ExternalTestCluster
extends TestCluster {
    private static final Logger logger = LogManager.getLogger(ExternalTestCluster.class);
    private static final AtomicInteger counter = new AtomicInteger();
    public static final String EXTERNAL_CLUSTER_PREFIX = "external_";
    private final MockNode node;
    private final Client client;
    private final InetSocketAddress[] httpAddresses;
    private final String clusterName;
    private final int numDataNodes;
    private final int numMasterAndDataNodes;

    public ExternalTestCluster(Path tempDir, Settings additionalSettings, Collection<Class<? extends Plugin>> pluginClasses, Function<Client, Client> clientWrapper, String clusterName, TransportAddress ... transportAddresses) {
        super(0L);
        boolean addMockTcpTransport;
        this.clusterName = clusterName;
        Settings.Builder clientSettingsBuilder = Settings.builder().put(additionalSettings).putList("node.roles", Collections.emptyList()).put("node.name", EXTERNAL_CLUSTER_PREFIX + counter.getAndIncrement()).put("cluster.name", clusterName).put(TransportSettings.PORT.getKey(), ESTestCase.getPortRange()).putList("discovery.seed_hosts", Arrays.stream(transportAddresses).map(TransportAddress::toString).collect(Collectors.toList()));
        if (!Environment.PATH_HOME_SETTING.exists(additionalSettings)) {
            clientSettingsBuilder.put(Environment.PATH_HOME_SETTING.getKey(), tempDir);
        }
        boolean bl = addMockTcpTransport = additionalSettings.get("transport.type") == null;
        if (addMockTcpTransport) {
            String transport = ESTestCase.getTestTransportType();
            clientSettingsBuilder.put("transport.type", transport);
            if (!pluginClasses.contains(ESTestCase.getTestTransportPlugin())) {
                pluginClasses = new ArrayList<Class<? extends Plugin>>(pluginClasses);
                pluginClasses.add(ESTestCase.getTestTransportPlugin());
            }
        }
        pluginClasses = new ArrayList<Class<? extends Plugin>>(pluginClasses);
        pluginClasses.add(MockHttpTransport.TestPlugin.class);
        Settings clientSettings = clientSettingsBuilder.build();
        MockNode mockNode = new MockNode(clientSettings, pluginClasses);
        Client wrappedClient = clientWrapper.apply(mockNode.client());
        try {
            mockNode.start();
            NodesInfoResponse nodeInfos = (NodesInfoResponse)wrappedClient.admin().cluster().prepareNodesInfo(new String[0]).clear().setSettings(true).setHttp(true).get();
            this.httpAddresses = new InetSocketAddress[nodeInfos.getNodes().size()];
            int dataNodes = 0;
            int masterAndDataNodes = 0;
            for (int i = 0; i < nodeInfos.getNodes().size(); ++i) {
                NodeInfo nodeInfo = (NodeInfo)nodeInfos.getNodes().get(i);
                this.httpAddresses[i] = ((HttpInfo)nodeInfo.getInfo(HttpInfo.class)).address().publishAddress().address();
                if (DiscoveryNode.canContainData((Settings)nodeInfo.getSettings())) {
                    ++dataNodes;
                    ++masterAndDataNodes;
                    continue;
                }
                if (!DiscoveryNode.isMasterNode((Settings)nodeInfo.getSettings())) continue;
                ++masterAndDataNodes;
            }
            this.numDataNodes = dataNodes;
            this.numMasterAndDataNodes = masterAndDataNodes;
            this.client = wrappedClient;
            this.node = mockNode;
            logger.info("Setup ExternalTestCluster [{}] made of [{}] nodes", (Object)nodeInfos.getClusterName().value(), (Object)this.size());
        }
        catch (NodeValidationException e) {
            try {
                IOUtils.close((Closeable)((Object)mockNode));
            }
            catch (IOException e1) {
                e.addSuppressed((Throwable)e1);
            }
            throw new ElasticsearchException((Throwable)e);
        }
        catch (Exception e) {
            try {
                IOUtils.close((Closeable)((Object)mockNode));
            }
            catch (IOException e1) {
                e.addSuppressed(e1);
            }
            throw e;
        }
    }

    @Override
    public void afterTest() {
    }

    @Override
    public Client client() {
        return this.client;
    }

    @Override
    public int size() {
        return this.httpAddresses.length;
    }

    @Override
    public int numDataNodes() {
        return this.numDataNodes;
    }

    @Override
    public int numDataAndMasterNodes() {
        return this.numMasterAndDataNodes;
    }

    @Override
    public InetSocketAddress[] httpAddresses() {
        return this.httpAddresses;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)((Object)this.node));
    }

    @Override
    public void ensureEstimatedStats() {
        if (this.size() > 0) {
            NodesStatsResponse nodeStats = (NodesStatsResponse)this.client().admin().cluster().prepareNodesStats(new String[0]).clear().setBreaker(true).setIndices(true).get();
            for (NodeStats stats : nodeStats.getNodes()) {
                Assert.assertThat((String)("Fielddata breaker not reset to 0 on node: " + String.valueOf(stats.getNode())), (Object)stats.getBreaker().getStats("fielddata").getEstimated(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("Fielddata size must be 0 on node: " + String.valueOf(stats.getNode())), (Object)stats.getIndices().getFieldData().getMemorySizeInBytes(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("Query cache size must be 0 on node: " + String.valueOf(stats.getNode())), (Object)stats.getIndices().getQueryCache().getMemorySizeInBytes(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("FixedBitSet cache size must be 0 on node: " + String.valueOf(stats.getNode())), (Object)stats.getIndices().getSegments().getBitsetMemoryInBytes(), (Matcher)Matchers.equalTo((Object)0L));
            }
        }
    }

    @Override
    public Iterable<Client> getClients() {
        return List.of(this.client);
    }

    @Override
    public NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.node.getNamedWriteableRegistry();
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }
}

