/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.SubnetCidrReservationType;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSubnetCidrReservationRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateSubnetCidrReservationRequest> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(CreateSubnetCidrReservationRequest.getter(CreateSubnetCidrReservationRequest::subnetId)).setter(CreateSubnetCidrReservationRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("SubnetId").build()}).build();
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(CreateSubnetCidrReservationRequest.getter(CreateSubnetCidrReservationRequest::cidr)).setter(CreateSubnetCidrReservationRequest.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").unmarshallLocationName("Cidr").build()}).build();
    private static final SdkField<String> RESERVATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationType").getter(CreateSubnetCidrReservationRequest.getter(CreateSubnetCidrReservationRequest::reservationTypeAsString)).setter(CreateSubnetCidrReservationRequest.setter(Builder::reservationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationType").unmarshallLocationName("ReservationType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateSubnetCidrReservationRequest.getter(CreateSubnetCidrReservationRequest::description)).setter(CreateSubnetCidrReservationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("Description").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateSubnetCidrReservationRequest.getter(CreateSubnetCidrReservationRequest::dryRun)).setter(CreateSubnetCidrReservationRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateSubnetCidrReservationRequest.getter(CreateSubnetCidrReservationRequest::tagSpecifications)).setter(CreateSubnetCidrReservationRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD, CIDR_FIELD, RESERVATION_TYPE_FIELD, DESCRIPTION_FIELD, DRY_RUN_FIELD, TAG_SPECIFICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSubnetCidrReservationRequest.memberNameToFieldInitializer();
    private final String subnetId;
    private final String cidr;
    private final String reservationType;
    private final String description;
    private final Boolean dryRun;
    private final List<TagSpecification> tagSpecifications;

    private CreateSubnetCidrReservationRequest(BuilderImpl builder) {
        super(builder);
        this.subnetId = builder.subnetId;
        this.cidr = builder.cidr;
        this.reservationType = builder.reservationType;
        this.description = builder.description;
        this.dryRun = builder.dryRun;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final SubnetCidrReservationType reservationType() {
        return SubnetCidrReservationType.fromValue(this.reservationType);
    }

    public final String reservationTypeAsString() {
        return this.reservationType;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubnetCidrReservationRequest)) {
            return false;
        }
        CreateSubnetCidrReservationRequest other = (CreateSubnetCidrReservationRequest)((Object)obj);
        return Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.reservationTypeAsString(), other.reservationTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dryRun(), other.dryRun()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSubnetCidrReservationRequest").add("SubnetId", (Object)this.subnetId()).add("Cidr", (Object)this.cidr()).add("ReservationType", (Object)this.reservationTypeAsString()).add("Description", (Object)this.description()).add("DryRun", (Object)this.dryRun()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "ReservationType": {
                return Optional.ofNullable(clazz.cast(this.reservationTypeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("Cidr", CIDR_FIELD);
        map.put("ReservationType", RESERVATION_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSubnetCidrReservationRequest, T> g) {
        return obj -> g.apply((CreateSubnetCidrReservationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String subnetId;
        private String cidr;
        private String reservationType;
        private String description;
        private Boolean dryRun;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubnetCidrReservationRequest model) {
            super(model);
            this.subnetId(model.subnetId);
            this.cidr(model.cidr);
            this.reservationType(model.reservationType);
            this.description(model.description);
            this.dryRun(model.dryRun);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getReservationType() {
            return this.reservationType;
        }

        public final void setReservationType(String reservationType) {
            this.reservationType = reservationType;
        }

        @Override
        public final Builder reservationType(String reservationType) {
            this.reservationType = reservationType;
            return this;
        }

        @Override
        public final Builder reservationType(SubnetCidrReservationType reservationType) {
            this.reservationType(reservationType == null ? null : reservationType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubnetCidrReservationRequest build() {
            return new CreateSubnetCidrReservationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSubnetCidrReservationRequest> {
        public Builder subnetId(String var1);

        public Builder cidr(String var1);

        public Builder reservationType(String var1);

        public Builder reservationType(SubnetCidrReservationType var1);

        public Builder description(String var1);

        public Builder dryRun(Boolean var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

