/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.builder;

import java.util.Deque;
import java.util.LinkedList;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.serialization.builder.ValueReader;

public abstract class AbstractValueReader
implements ValueReader {
    private final Deque<FieldContext> nestedFieldContexts = new LinkedList<FieldContext>();

    protected FieldContext getCurrentField() {
        return this.nestedFieldContexts.peek();
    }

    @Override
    public void beginField(String fieldName) {
        FieldContext fieldContext = new FieldContext();
        fieldContext.setFieldName(fieldName);
        fieldContext.setArrayDepth(0);
        this.nestedFieldContexts.push(fieldContext);
    }

    @Override
    public void endField(String fieldName) {
        FieldContext ctx = this.nestedFieldContexts.pop();
        if (ctx == null) {
            throw new EsHadoopIllegalStateException("Trying to end parsing of field [" + fieldName + "] but no field has been marked to begin parsing.");
        }
        if (!ctx.fieldName.equals(fieldName)) {
            throw new EsHadoopIllegalStateException("Trying to end parsing of field [" + fieldName + "] but the current field [" + ctx.fieldName + "] is being parsed.");
        }
    }

    public static class FieldContext {
        private String fieldName;
        private int arrayDepth;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public int getArrayDepth() {
            return this.arrayDepth;
        }

        public void setArrayDepth(int arrayDepth) {
            this.arrayDepth = arrayDepth;
        }
    }
}

