/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.Type;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.JsonGenerationException;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.JsonGenerator;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.JsonNode;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.io.SerializedString;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.AnnotationIntrospector;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.SerializationConfig;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.SerializerProvider;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.annotate.JacksonStdImpl;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.ser.ScalarSerializerBase;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.util.EnumValues;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.node.ArrayNode;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.node.ObjectNode;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class EnumSerializer
extends ScalarSerializerBase<Enum<?>> {
    protected final EnumValues _values;

    public EnumSerializer(EnumValues v) {
        super(Enum.class, false);
        this._values = v;
    }

    public static EnumSerializer construct(Class<Enum<?>> enumClass, SerializationConfig config, BasicBeanDescription beanDesc) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        EnumValues v = config.isEnabled(SerializationConfig.Feature.WRITE_ENUMS_USING_TO_STRING) ? EnumValues.constructFromToString(enumClass, intr) : EnumValues.constructFromName(enumClass, intr);
        return new EnumSerializer(v);
    }

    @Override
    public final void serialize(Enum<?> en, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeString(this._values.serializedValueFor(en));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        JavaType type;
        ObjectNode objectNode = this.createSchemaNode("string", true);
        if (typeHint != null && (type = provider.constructType(typeHint)).isEnumType()) {
            ArrayNode enumNode = objectNode.putArray("enum");
            for (SerializedString value : this._values.values()) {
                enumNode.add(value.getValue());
            }
        }
        return objectNode;
    }

    public EnumValues getEnumValues() {
        return this._values;
    }
}

