/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.settings;

import java.util.function.Predicate;
import org.logstash.settings.Coercible;

public class IntegerSetting
extends Coercible<Integer> {
    public IntegerSetting(String name, Integer defaultValue) {
        super(name, defaultValue, true, IntegerSetting.noValidator());
    }

    public IntegerSetting(String name, Integer defaultValue, boolean strict) {
        super(name, defaultValue, strict, IntegerSetting.noValidator());
    }

    protected IntegerSetting(String name, Integer defaultValue, boolean strict, Predicate<Integer> validator) {
        super(name, defaultValue, strict, validator);
    }

    @Override
    public Integer coerce(Object obj) {
        if (!(obj instanceof String)) {
            if (obj instanceof Integer) {
                return (Integer)obj;
            }
            if (obj instanceof Long) {
                return ((Long)obj).intValue();
            }
        } else {
            try {
                return Integer.parseInt(obj.toString().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(this.coercionFailureMessage(obj));
    }

    private String coercionFailureMessage(Object obj) {
        return String.format("Failed to coerce value to IntegerSetting. Received %s (%s)", obj, obj.getClass());
    }
}

