/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;

public class JavaLogAdapter
implements LogAdapter {
    private final Logger logger;

    public JavaLogAdapter(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isLoggable(LogLevel.DEBUG);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isLoggable(LogLevel.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isLoggable(LogLevel.WARN);
    }

    @Override
    public void debug(Serializable message) {
        this.log(LogLevel.DEBUG, message.toString(), null);
    }

    @Override
    public void info(CharSequence message) {
        this.log(LogLevel.INFO, message.toString(), null);
    }

    @Override
    public void warn(Serializable message) {
        this.log(LogLevel.WARN, message.toString(), null);
    }

    @Override
    public void error(Serializable message) {
        this.log(LogLevel.ERROR, message.toString(), null);
    }

    @Override
    public void error(CharSequence message, Throwable t) {
        this.log(LogLevel.ERROR, message.toString(), t);
    }

    @Override
    public void fatal(Object message) {
        this.log(LogLevel.FATAL, message.toString(), null);
    }

    @Override
    public void fatal(CharSequence message, Throwable t) {
        this.log(LogLevel.FATAL, message.toString(), t);
    }

    @Override
    public LogLevel getEffectiveLogLevel() {
        Logger effectiveLogger;
        for (effectiveLogger = this.logger; effectiveLogger != null && effectiveLogger.getLevel() == null; effectiveLogger = effectiveLogger.getParent()) {
        }
        return JavaLogAdapter.fromJavaToSnmp4jLevel(effectiveLogger != null ? effectiveLogger.getLevel() : this.logger.getLevel());
    }

    public Iterator<Handler> getLogHandler() {
        return Arrays.asList(this.logger.getHandlers()).iterator();
    }

    @Override
    public LogLevel getLogLevel() {
        return JavaLogAdapter.fromJavaToSnmp4jLevel(this.logger.getLevel());
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logger.setLevel(JavaLogAdapter.fromSnmp4jToJdk(logLevel));
    }

    private boolean isLoggable(LogLevel logLevel) {
        return this.logger.isLoggable(JavaLogAdapter.fromSnmp4jToJdk(logLevel));
    }

    private void log(LogLevel logLevel, String msg, Throwable t) {
        this.logger.log(JavaLogAdapter.fromSnmp4jToJdk(logLevel), msg, t);
    }

    public static Level fromSnmp4jToJdk(LogLevel logLevel) {
        if (logLevel == null) {
            return null;
        }
        switch (logLevel.getLevel()) {
            case 2: {
                return Level.ALL;
            }
            case 4: {
                return Level.FINE;
            }
            case 3: {
                return Level.FINEST;
            }
            case 5: {
                return Level.INFO;
            }
            case 6: {
                return Level.WARNING;
            }
            case 7: 
            case 8: {
                return Level.SEVERE;
            }
            case 0: {
                return null;
            }
            case 1: {
                return Level.OFF;
            }
        }
        throw new IllegalArgumentException("Mapping not defined from SNMP4J level " + String.valueOf(logLevel) + " to Java logging level");
    }

    public static LogLevel fromJavaToSnmp4jLevel(Level level) {
        if (level == null) {
            return LogLevel.NONE;
        }
        if (Level.ALL.equals(level)) {
            return LogLevel.ALL;
        }
        if (Level.SEVERE.equals(level)) {
            return LogLevel.ERROR;
        }
        if (Level.WARNING.equals(level)) {
            return LogLevel.WARN;
        }
        if (Level.INFO.equals(level)) {
            return LogLevel.INFO;
        }
        if (Level.CONFIG.equals(level)) {
            return LogLevel.INFO;
        }
        if (Level.FINE.equals(level)) {
            return LogLevel.DEBUG;
        }
        if (Level.FINER.equals(level)) {
            return LogLevel.TRACE;
        }
        if (Level.FINEST.equals(level)) {
            return LogLevel.TRACE;
        }
        if (Level.OFF.equals(level)) {
            return LogLevel.OFF;
        }
        throw new IllegalArgumentException("Mapping not defined from Java level " + level.getName() + " to SNMP4J logging level");
    }

    public String toString() {
        return this.getName();
    }

    public Logger getJavaLogger() {
        return this.logger;
    }
}

