"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIndexModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _api = require("../../../api/api");
var _use_privileged_monitoring_health = require("../../../hooks/use_privileged_monitoring_health");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring_onboarding/components/create_index_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var IndexMode = /*#__PURE__*/function (IndexMode) {
  IndexMode["STANDARD"] = "standard";
  IndexMode["LOOKUP"] = "lookup";
  return IndexMode;
}(IndexMode || {});
const INDEX_NAME_LABEL = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.indexNameLabel', {
  defaultMessage: 'Index name'
});
const INDEX_MODE_LABEL = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.indexModeLabel', {
  defaultMessage: 'Index mode'
});
const INDEX_MODES = [{
  value: IndexMode.STANDARD,
  text: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.mode.standard', {
    defaultMessage: 'Standard'
  })
}, {
  value: IndexMode.LOOKUP,
  text: _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.mode.lookup', {
    defaultMessage: 'Lookup'
  })
}];
const CreateIndexModal = ({
  onClose,
  onCreate
}) => {
  var _userStats$maxAllowed;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [indexName, setIndexName] = (0, _react.useState)('');
  const [indexMode, setIndexMode] = (0, _react.useState)(IndexMode.STANDARD);
  const [error, setError] = (0, _react.useState)(null);
  const {
    createPrivMonImportIndex
  } = (0, _api.useEntityAnalyticsRoutes)();
  const {
    userStats
  } = (0, _use_privileged_monitoring_health.useUserLimitStatus)();
  const maxUsersAllowed = (_userStats$maxAllowed = userStats === null || userStats === void 0 ? void 0 : userStats.maxAllowed) !== null && _userStats$maxAllowed !== void 0 ? _userStats$maxAllowed : 10000; // fallback to default config value

  const handleCreate = (0, _react.useCallback)(async () => {
    setError(null);
    const trimmedName = indexName.trim();
    try {
      await createPrivMonImportIndex({
        name: trimmedName,
        mode: indexMode
      });
      onCreate(trimmedName);
    } catch (err) {
      setError(_i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.error', {
        defaultMessage: 'Error creating index: {error}',
        values: {
          error: err.body.message || err.message || 'Unknown error'
        }
      }));
    }
  }, [indexName, createPrivMonImportIndex, indexMode, onCreate]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    maxWidth: "624px",
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.title",
    defaultMessage: "Create index",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }, error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  }, error), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.description",
    defaultMessage: "Create an index to store your privileged users (maximum number allowed: {maxUsersAllowed}). After creating it, make sure to index documents with the {nameField} field using your preferred method.",
    values: {
      nameField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 28
        }
      }, 'user.name'),
      maxUsersAllowed: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 34
        }
      }, maxUsersAllowed)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: INDEX_NAME_LABEL,
    fullWidth: true,
    error: !!error && !indexName.trim() ? error : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: indexName,
    onChange: e => setIndexName(e.target.value),
    "aria-label": INDEX_NAME_LABEL,
    "data-test-subj": "createIndexModalIndexName",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: INDEX_MODE_LABEL,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: INDEX_MODES,
    value: indexMode,
    onChange: e => setIndexMode(e.target.value),
    "aria-label": INDEX_MODE_LABEL,
    "data-test-subj": "createIndexModalIndexMode",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.cancelButtonAriaLabel', {
      defaultMessage: 'Cancel'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleCreate,
    fill: true,
    disabled: !indexName.trim(),
    "data-test-subj": "createIndexModalCreateButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.createIndex.createButtonLabel",
    defaultMessage: "Create index",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 17
    }
  })))))));
};
exports.CreateIndexModal = CreateIndexModal;