"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_MIN_CHART_HEIGHT = exports.AlertsTreemap = void 0;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _common = require("../../../../../common/components/charts/common");
var _draggable_legend = require("../../../../../common/components/charts/draggable_legend");
var _chart_palette = require("./lib/chart_palette");
var _get_flattened_buckets = require("./lib/flatten/get_flattened_buckets");
var _get_flattened_legend_items = require("./lib/legend/get_flattened_legend_items");
var _helpers = require("./lib/helpers");
var _layers = require("./lib/layers");
var _legend = require("./lib/legend");
var _no_data = require("./no_data");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_kpis/alerts_treemap_panel/alerts_treemap/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_MIN_CHART_HEIGHT = exports.DEFAULT_MIN_CHART_HEIGHT = 240; // px
const DEFAULT_LEGEND_WIDTH = 300; // px

const LegendContainer = _styledComponents.default.div`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const ChartFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-height: ${({
  $minChartHeight
}) => `${$minChartHeight}px`};
`;
const AlertsTreemapComponent = ({
  addFilter,
  data,
  maxBuckets,
  minChartHeight = DEFAULT_MIN_CHART_HEIGHT,
  stackByField0,
  stackByField1
}) => {
  var _theme$background2, _data$aggregations2, _data$aggregations2$s;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    theme,
    baseTheme
  } = (0, _common.useThemes)();
  const fillColor = (0, _react.useMemo)(() => {
    var _theme$background$col, _theme$background;
    return (_theme$background$col = theme === null || theme === void 0 ? void 0 : (_theme$background = theme.background) === null || _theme$background === void 0 ? void 0 : _theme$background.color) !== null && _theme$background$col !== void 0 ? _theme$background$col : baseTheme.background.color;
  }, [theme === null || theme === void 0 ? void 0 : (_theme$background2 = theme.background) === null || _theme$background2 === void 0 ? void 0 : _theme$background2.color, baseTheme.background.color]);
  const treemapTheme = (0, _react.useMemo)(() => ({
    partition: {
      fillLabel: {
        valueFont: {
          fontWeight: 700
        }
      },
      idealFontSizeJump: 1.15,
      maxFontSize: 16,
      minFontSize: 4,
      sectorLineStroke: fillColor,
      // draws the light or dark "lines" between partitions
      sectorLineWidth: 1.5
    }
  }), [fillColor]);
  const buckets = (0, _react.useMemo)(() => {
    var _data$aggregations, _data$aggregations$st;
    return (0, _helpers.getUpToMaxBuckets)({
      buckets: (_data$aggregations = data.aggregations) === null || _data$aggregations === void 0 ? void 0 : (_data$aggregations$st = _data$aggregations.stackByField0) === null || _data$aggregations$st === void 0 ? void 0 : _data$aggregations$st.buckets,
      maxItems: maxBuckets
    });
  }, [(_data$aggregations2 = data.aggregations) === null || _data$aggregations2 === void 0 ? void 0 : (_data$aggregations2$s = _data$aggregations2.stackByField0) === null || _data$aggregations2$s === void 0 ? void 0 : _data$aggregations2$s.buckets, maxBuckets]);
  const maxRiskSubAggregations = (0, _react.useMemo)(() => (0, _helpers.getMaxRiskSubAggregations)(buckets), [buckets]);
  const flattenedBuckets = (0, _react.useMemo)(() => (0, _get_flattened_buckets.getFlattenedBuckets)({
    buckets,
    maxRiskSubAggregations,
    stackByField0
  }), [buckets, maxRiskSubAggregations, stackByField0]);
  const colorPalette = (0, _react.useMemo)(() => (0, _chart_palette.getRiskScorePalette)(_chart_palette.RISK_SCORE_STEPS, euiTheme), [euiTheme]);
  const legendItems = (0, _react.useMemo)(() => flattenedBuckets.length === 0 ? (0, _legend.getFirstGroupLegendItems)({
    buckets,
    colorPalette,
    maxRiskSubAggregations,
    stackByField0
  }) : (0, _get_flattened_legend_items.getFlattenedLegendItems)({
    buckets,
    colorPalette,
    flattenedBuckets,
    maxRiskSubAggregations,
    stackByField0,
    stackByField1
  }), [buckets, colorPalette, flattenedBuckets, maxRiskSubAggregations, stackByField0, stackByField1]);
  const onElementClick = (0, _react.useCallback)(event => {
    const {
      groupByField0,
      groupByField1
    } = (0, _helpers.getGroupByFieldsOnClick)(event);
    if (addFilter != null && !(0, _fp.isEmpty)(groupByField0.trim())) {
      addFilter({
        field: stackByField0,
        value: groupByField0
      });
    }
    if (addFilter != null && !(0, _fp.isEmpty)(stackByField1 === null || stackByField1 === void 0 ? void 0 : stackByField1.trim()) && !(0, _fp.isEmpty)(groupByField1.trim())) {
      addFilter({
        field: `${stackByField1}`,
        value: groupByField1
      });
    }
  }, [addFilter, stackByField0, stackByField1]);
  const layers = (0, _react.useMemo)(() => (0, _helpers.hasOptionalStackByField)(stackByField1) ? (0, _layers.getLayersMultiDimensional)({
    colorPalette,
    layer0FillColor: fillColor,
    maxRiskSubAggregations
  }) : (0, _layers.getLayersOneDimension)({
    colorPalette,
    maxRiskSubAggregations
  }), [colorPalette, fillColor, maxRiskSubAggregations, stackByField1]);
  const valueAccessor = (0, _react.useMemo)(() => (0, _helpers.hasOptionalStackByField)(stackByField1) ? d => d.stackByField1DocCount : d => d.doc_count, [stackByField1]);
  const normalizedData = (0, _helpers.hasOptionalStackByField)(stackByField1) ? flattenedBuckets : buckets;
  if (buckets.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_no_data.NoData, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "alerts-treemap",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ChartFlexItem, {
    grow: true,
    $minChartHeight: minChartHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  }, stackByField1 != null && !(0, _fp.isEmpty)(stackByField1) && normalizedData.length === 0 ? /*#__PURE__*/_react.default.createElement(_no_data.NoData, {
    reason: (0, _translations.NO_DATA_REASON_LABEL)(stackByField1),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    showLegend: false,
    theme: [treemapTheme, theme],
    onElementClick: onElementClick,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    data: normalizedData,
    id: "spec_1",
    layers: layers,
    layout: _charts.PartitionLayout.treemap,
    valueAccessor: valueAccessor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(LegendContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  }, legendItems.length > 0 && /*#__PURE__*/_react.default.createElement(_draggable_legend.DraggableLegend, {
    className: "eui-yScroll",
    height: minChartHeight,
    legendItems: legendItems,
    minWidth: DEFAULT_LEGEND_WIDTH,
    isInlineActions: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 15
    }
  })))));
};
const AlertsTreemap = exports.AlertsTreemap = /*#__PURE__*/_react.default.memo(AlertsTreemapComponent);