"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FiltersSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _page_filters = require("./page_filters");
var _use_data_table_filters = require("../../../../common/hooks/use_data_table_filters");
var _use_selector = require("../../../../common/hooks/use_selector");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _inputs = require("../../../../common/store/inputs");
var _default_config = require("../../alerts_table/default_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts/filters/filters_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * UI section of the alerts page that renders the page filters
 */
const FiltersSection = exports.FiltersSection = /*#__PURE__*/(0, _react.memo)(({
  assignees,
  dataView,
  setPageFilterHandler,
  setPageFilters,
  setStatusFilter
}) => {
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const {
    showBuildingBlockAlerts,
    showOnlyThreatIndicatorAlerts
  } = (0, _use_data_table_filters.useDataTableFilters)(_securitysolutionDataTable.TableId.alertsOnAlertsPage);
  const topLevelFilters = (0, _react.useMemo)(() => {
    return [...filters, ...(0, _default_config.buildShowBuildingBlockFilter)(showBuildingBlockAlerts), ...(0, _default_config.buildThreatMatchFilter)(showOnlyThreatIndicatorAlerts), ...(0, _default_config.buildAlertAssigneesFilter)(assignees)];
  }, [assignees, showBuildingBlockAlerts, showOnlyThreatIndicatorAlerts, filters]);
  const onFilterControlsChange = (0, _react.useCallback)(newFilters => {
    setPageFilters(newFilters);
    if (!newFilters.length) return;
    const newStatusFilter = newFilters.find(filter => filter.meta.key === 'kibana.alert.workflow_status');
    if (newStatusFilter) {
      var _newStatusFilter$quer;
      const status = newStatusFilter.meta.params ? newStatusFilter.meta.params : [(_newStatusFilter$quer = newStatusFilter.query) === null || _newStatusFilter$quer === void 0 ? void 0 : _newStatusFilter$quer.match_phrase['kibana.alert.workflow_status']];
      setStatusFilter(status);
    } else {
      setStatusFilter([]);
    }
  }, [setPageFilters, setStatusFilter]);
  const pageFiltersTimeRange = (0, _react.useMemo)(() => ({
    from,
    to,
    mode: 'absolute'
  }), [from, to]);
  return /*#__PURE__*/_react.default.createElement(_page_filters.PageFilters, {
    filters: topLevelFilters,
    onFiltersChange: onFilterControlsChange,
    query: query,
    timeRange: pageFiltersTimeRange,
    onInit: setPageFilterHandler,
    dataView: dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  });
});
FiltersSection.displayName = 'FiltersSection';