"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KPIsSection = exports.KPIS_SECTION = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _store = require("../../../../common/store");
var _use_selector = require("../../../../common/hooks/use_selector");
var _severity_level_panel = require("../../alerts_kpis/severity_level_panel");
var _alerts_by_rule_panel = require("../../alerts_kpis/alerts_by_rule_panel");
var _alerts_progress_bar_by_host_name_panel = require("./alerts_progress_bar_by_host_name_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alert_summary/kpis/kpis_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const KPIS_SECTION = exports.KPIS_SECTION = 'alert-summary-kpis-section';
/**
 * Section rendering 3 charts in the alert summary page.
 * The component leverages existing chart components from the alerts page but is making a few tweaks:
 * - the SeverityLevelPanel and AlertsByRulePanel are used directly from the alerts page
 * - the UI differences on the AlertsProgressBarPanel were significant enough that a separate component was created
 */
const KPIsSection = exports.KPIsSection = /*#__PURE__*/(0, _react.memo)(({
  signalIndexName
}) => {
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const getGlobalFiltersSelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersSelector);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": KPIS_SECTION,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_severity_level_panel.SeverityLevelPanel, {
    filters: filters,
    signalIndexName: signalIndexName,
    query: query,
    showCellActions: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_by_rule_panel.AlertsByRulePanel, {
    filters: filters,
    signalIndexName: signalIndexName,
    query: query,
    showCellActions: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_progress_bar_by_host_name_panel.AlertsProgressBarByHostNamePanel, {
    filters: filters,
    signalIndexName: signalIndexName,
    query: query,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  })));
});
KPIsSection.displayName = 'KPIsSection';