"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommentField = void 0;
var _react = _interopRequireDefault(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_response_actions/endpoint/comment_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CONFIG = {
  label: _i18n.i18n.translate('xpack.securitySolution.responseActions.endpoint.commentLabel', {
    defaultMessage: 'Comment (optional)'
  }),
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.responseActions.endpoint.commentDescription",
    defaultMessage: "Leave a note that explains or describes the action. Your comment is included in the response actions history.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  })
};
const CommentFieldComponent = ({
  basePath,
  disabled,
  readDefaultValueOnForm
}) => /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: `${basePath}.comment`,
  readDefaultValueOnForm: readDefaultValueOnForm,
  config: CONFIG,
  isDisabled: disabled,
  component: _components.TextField,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 3
  }
});
const CommentField = exports.CommentField = /*#__PURE__*/_react.default.memo(CommentFieldComponent);