"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assertDiffAfterSavingUnchangedValue = assertDiffAfterSavingUnchangedValue;
var _react = require("@testing-library/react");
var _detection_engine = require("../../../../../../../../common/api/detection_engine");
var _rule_upgrade_helpers = require("./rule_upgrade_helpers");
var _rule_upgrade_flyout = require("./rule_upgrade_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function assertDiffAfterSavingUnchangedValue({
  ruleType,
  fieldName: rawFieldName,
  fieldVersions: {
    initial,
    upgrade
  }
}) {
  // TS isn't able to infer the type of the field name for inputFieldValue()
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const fieldName = rawFieldName;
  describe('diff view', () => {
    it('shows the same diff after saving unchanged field value', async () => {
      (0, _rule_upgrade_flyout.mockRuleUpgradeReviewData)({
        ruleType,
        fieldName,
        fieldVersions: {
          base: initial,
          current: initial,
          target: upgrade,
          merged: upgrade
        },
        diffOutcome: _detection_engine.ThreeWayDiffOutcome.StockValueCanUpdate,
        conflict: _detection_engine.ThreeWayDiffConflict.NONE
      });
      const {
        getByTestId
      } = await (0, _rule_upgrade_flyout.renderRuleUpgradeFlyout)();
      const fieldUpgradeWrapper = getByTestId(`${fieldName}-upgradeWrapper`);
      const diffViewSection = (0, _react.within)(fieldUpgradeWrapper).getByTestId(`${fieldName}-comparisonSide`);
      (0, _rule_upgrade_helpers.toggleFieldAccordion)(fieldUpgradeWrapper);

      // We have to track subfield diff views
      const diffViewContents = getDiffViews(diffViewSection).map(el => el.textContent);
      (0, _rule_upgrade_helpers.switchToFieldEdit)(fieldUpgradeWrapper);
      await (0, _rule_upgrade_helpers.saveFieldValue)(fieldUpgradeWrapper);
      const diffViews = getDiffViews(diffViewSection);
      expect(diffViews.length).toBe(diffViewContents.length);
      for (let i = 0; i < diffViews.length; ++i) {
        // It's been observed a number of whitespaces may change
        expect(removeWhitespaces(diffViews[i].textContent)).toBe(removeWhitespaces(diffViewContents[i]));
      }
    });
  });
}
function getDiffViews(container) {
  return (0, _react.within)(container).getAllByTestId('prebuilt-rule-upgrade-diff-view');
}
function removeWhitespaces(str) {
  return str.replace(/\s/g, '');
}