"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOutdatedMlJobsUpgradeModal = useOutdatedMlJobsUpgradeModal;
var _react = _interopRequireWildcard(require("react"));
var _reactHooks = require("@kbn/react-hooks");
var _use_installed_security_jobs = require("../../../../../../common/components/ml/hooks/use_installed_security_jobs");
var _affected_job_ids = require("../../../../../../../common/machine_learning/affected_job_ids");
var _use_async_confirmation = require("../../rules_table/use_async_confirmation");
var _ml_jobs_upgrade_modal = require("./ml_jobs_upgrade_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/use_ml_jobs_upgrade_modal/use_ml_jobs_upgrade_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useOutdatedMlJobsUpgradeModal() {
  const [isVisible, {
    on: showModal,
    off: hideModal
  }] = (0, _reactHooks.useBoolean)(false);
  const {
    loading,
    jobs
  } = (0, _use_installed_security_jobs.useInstalledSecurityJobs)();
  const legacyJobsInstalled = jobs.filter(job => _affected_job_ids.affectedJobIds.includes(job.id));
  const [confirmLegacyMLJobs, confirm, cancel] = (0, _use_async_confirmation.useAsyncConfirmation)({
    onInit: showModal,
    onFinish: hideModal
  });
  const handleLegacyMLJobsConfirm = (0, _react.useCallback)(async () => {
    if (legacyJobsInstalled.length > 0) {
      return confirmLegacyMLJobs();
    }
    return true;
  }, [confirmLegacyMLJobs, legacyJobsInstalled]);
  return {
    modal: isVisible && /*#__PURE__*/_react.default.createElement(_ml_jobs_upgrade_modal.OutdatedMlJobsUpgradeModal, {
      jobs: jobs,
      onConfirm: confirm,
      onCancel: cancel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 7
      }
    }),
    confirmLegacyMLJobs: handleLegacyMLJobsConfirm,
    isLoading: loading
  };
}