"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetAlertSuppressionForThresholdForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _telemetry = require("../../../../../../common/lib/telemetry");
var _rule_management = require("../../../../../../../common/api/detection_engine/rule_management");
var _shared_imports = require("../../../../../../shared_imports");
var _bulk_edit_form_wrapper = require("./bulk_edit_form_wrapper");
var _alert_suppression_edit = require("../../../../../rule_creation/components/alert_suppression_edit");
var _translations = require("../translations");
var _duration_input = require("../../../../../rule_creation/components/duration_input");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/bulk_actions/forms/set_alert_suppression_for_threshold_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const initialFormData = _alert_suppression_edit.ALERT_SUPPRESSION_DEFAULT_DURATION;
const SetAlertSuppressionForThresholdForm = exports.SetAlertSuppressionForThresholdForm = /*#__PURE__*/_react.default.memo(function SetAlertSuppressionForm({
  editAction,
  rulesCount,
  onClose,
  onConfirm
}) {
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: initialFormData
  });
  const handleSubmit = async () => {
    const {
      data,
      isValid
    } = await form.submit();
    if (!isValid) {
      return;
    }
    onConfirm({
      value: {
        duration: data
      },
      type: _rule_management.BulkActionEditTypeEnum.set_alert_suppression_for_threshold
    });
    (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, _telemetry.TELEMETRY_EVENT.SET_ALERT_SUPPRESSION_FOR_THRESHOLD);
  };
  return /*#__PURE__*/_react.default.createElement(_bulk_edit_form_wrapper.BulkEditFormWrapper, {
    form: form,
    onClose: onClose,
    onSubmit: handleSubmit,
    title: _translations.bulkAlertSuppression.SET_FOR_THRESHOLD_TITLE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "info",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, _translations.bulkAlertSuppression.SUPPRESSION_FOR_THRESHOLD_INFO_TEXT))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "alertSuppressionDuration",
    label: _translations.bulkAlertSuppression.DURATION_PER_TIME_PERIOD_LABEL,
    helpText: _translations.bulkAlertSuppression.DURATION_PER_TIME_PERIOD_HELP_TEXT,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: {
      suppressionDurationValue: {
        path: `value`
      },
      suppressionDurationUnit: {
        path: `unit`
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, ({
    suppressionDurationValue,
    suppressionDurationUnit
  }) => /*#__PURE__*/_react.default.createElement(_duration_input.DurationInput, {
    isDisabled: false,
    durationValueField: suppressionDurationValue,
    durationUnitField: suppressionDurationUnit,
    "aria-label": _translations.bulkAlertSuppression.DURATION_PER_TIME_PERIOD_INPUT,
    minimumValue: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }))));
});