"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNumOfCoveredSubtechniques = void 0;
var _detection_engine = require("../../../../../common/api/detection_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNumOfCoveredSubtechniques = (technique, activity) => {
  const coveredSubtechniques = new Set();
  for (const subtechnique of technique.subtechniques) {
    if ((!activity || activity.includes(_detection_engine.CoverageOverviewRuleActivity.Enabled)) && subtechnique.enabledRules.length) {
      coveredSubtechniques.add(subtechnique.id);
    }
    if ((!activity || activity.includes(_detection_engine.CoverageOverviewRuleActivity.Disabled)) && subtechnique.disabledRules.length) {
      coveredSubtechniques.add(subtechnique.id);
    }
  }
  return coveredSubtechniques.size;
};
exports.getNumOfCoveredSubtechniques = getNumOfCoveredSubtechniques;