"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimestampOverride = exports.ThreatIndicatorPath = exports.Threat = exports.Tags = exports.SeverityMappingItem = exports.RuleNameOverride = exports.RuleAboutSection = exports.RiskScoreMappingItem = exports.RiskScore = exports.References = exports.MaxSignals = exports.License = exports.InvestigationFields = exports.FalsePositives = exports.Description = exports.BuildingBlock = exports.Author = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _severity_badge = require("../../../../common/components/severity_badge");
var _empty_value = require("../../../../common/components/empty_value");
var _helpers = require("../../../rule_creation_ui/pages/rule_creation/helpers");
var _threat_description = require("../../../rule_creation_ui/components/description_step/threat_description");
var _badge_list = require("./badge_list");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _rule_field_name = require("./rule_field_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/rule_about_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OverrideColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 125px;
  max-width: 125px;
  overflow: hidden;
  text-overflow: ellipsis;
`;
const OverrideValueColumn = _styledComponents.default.div`
  width: 50px;
  overflow: hidden;
  white-space: nowrap;
  text-overflow: ellipsis;
`;
const StyledEuiLink = (0, _styledComponents.default)(_eui.EuiLink)`
  word-break: break-word;
`;
const Name = ({
  name
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 65,
    columnNumber: 39
  }
}, name);
const Description = ({
  description
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 72,
    columnNumber: 3
  }
}, description);
exports.Description = Description;
const Author = ({
  author
}) => /*#__PURE__*/_react.default.createElement(_badge_list.BadgeList, {
  badges: author,
  "data-test-subj": "authorPropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 80,
    columnNumber: 3
  }
});
exports.Author = Author;
const BuildingBlock = ({
  type
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "buildingBlockPropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 88,
    columnNumber: 3
  }
}, type ? i18n.BUILDING_BLOCK_ENABLED_FIELD_DESCRIPTION : i18n.BUILDING_BLOCK_DISABLED_FIELD_DESCRIPTION);
exports.BuildingBlock = BuildingBlock;
const SeverityMappingItem = ({
  severityMappingItem
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 100,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(OverrideColumn, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 101,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: severityMappingItem.field,
  "data-test-subj": `severityOverrideField-${severityMappingItem.value}`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 102,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement("span", {
  tabIndex: 0,
  "data-test-subj": "severityOverrideField",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 106,
    columnNumber: 9
  }
}, `${severityMappingItem.field}:`))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 112,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: severityMappingItem.value,
  "data-test-subj": `severityOverrideValue-${severityMappingItem.value}`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 113,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(OverrideValueColumn, {
  tabIndex: 0,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 117,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement("span", {
  "data-test-subj": "severityOverrideValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 118,
    columnNumber: 11
  }
}, (0, _empty_value.defaultToEmptyTag)(severityMappingItem.value))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 124,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: 'sortRight',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 125,
    columnNumber: 7
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 127,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
  "data-test-subj": "severityOverrideSeverity",
  value: severityMappingItem.severity,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 128,
    columnNumber: 7
  }
})));
exports.SeverityMappingItem = SeverityMappingItem;
const RiskScore = ({
  riskScore
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "riskScorePropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 141,
    columnNumber: 3
  }
}, riskScore);
exports.RiskScore = RiskScore;
const RiskScoreMappingItem = ({
  riskScoreMappingItem
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 151,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(OverrideColumn, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 152,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: riskScoreMappingItem.field,
  "data-test-subj": `riskScoreOverrideField-${riskScoreMappingItem.value}`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 153,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement("span", {
  tabIndex: 0,
  "data-test-subj": "riskScoreOverridePropertyFieldName",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 157,
    columnNumber: 9
  }
}, riskScoreMappingItem.field))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 162,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: 'sortRight',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 163,
    columnNumber: 7
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  "data-test-subj": "riskScoreOverridePropertyOverride",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 165,
    columnNumber: 5
  }
}, _ruleDataUtils.ALERT_RISK_SCORE));
exports.RiskScoreMappingItem = RiskScoreMappingItem;
const References = ({
  references
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 174,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement("ul", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 175,
    columnNumber: 5
  }
}, references.filter(reference => !(0, _fp.isEmpty)(reference)).map((reference, index) => /*#__PURE__*/_react.default.createElement("li", {
  "data-test-subj": "urlsDescriptionReferenceLinkItem",
  key: `${index}-${reference}`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 179,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(StyledEuiLink, {
  href: reference,
  external: true,
  target: "_blank",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 180,
    columnNumber: 13
  }
}, reference)))));
exports.References = References;
const FalsePositives = ({
  falsePositives
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 190,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement("ul", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 191,
    columnNumber: 5
  }
}, falsePositives.map(falsePositivesItem => /*#__PURE__*/_react.default.createElement("li", {
  "data-test-subj": "falsePositivesPropertyValueItem",
  key: `falsePositives-${falsePositivesItem}`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 193,
    columnNumber: 9
  }
}, falsePositivesItem))));
exports.FalsePositives = FalsePositives;
const InvestigationFields = ({
  investigationFields
}) => /*#__PURE__*/_react.default.createElement(_badge_list.BadgeList, {
  badges: investigationFields,
  "data-test-subj": "investigationFieldsPropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 209,
    columnNumber: 3
  }
});
exports.InvestigationFields = InvestigationFields;
const License = ({
  license
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "licensePropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 217,
    columnNumber: 3
  }
}, license);
exports.License = License;
const RuleNameOverride = ({
  ruleNameOverride
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "ruleNameOverridePropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 227,
    columnNumber: 3
  }
}, ruleNameOverride);
exports.RuleNameOverride = RuleNameOverride;
const Threat = ({
  threat
}) => /*#__PURE__*/_react.default.createElement(_threat_description.ThreatEuiFlexGroup, {
  threat: (0, _helpers.filterEmptyThreats)(threat),
  "data-test-subj": "threatPropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 237,
    columnNumber: 3
  }
});
exports.Threat = Threat;
const ThreatIndicatorPath = ({
  threatIndicatorPath
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 245,
    columnNumber: 3
  }
}, threatIndicatorPath);
exports.ThreatIndicatorPath = ThreatIndicatorPath;
const TimestampOverride = ({
  timestampOverride
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "timestampOverridePropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 253,
    columnNumber: 3
  }
}, timestampOverride);
exports.TimestampOverride = TimestampOverride;
const MaxSignals = ({
  maxSignals
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": "maxSignalsPropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 263,
    columnNumber: 3
  }
}, maxSignals);
exports.MaxSignals = MaxSignals;
const Tags = ({
  tags
}) => /*#__PURE__*/_react.default.createElement(_badge_list.BadgeList, {
  badges: tags,
  "data-test-subj": "tagsPropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 273,
    columnNumber: 3
  }
});
exports.Tags = Tags;
// eslint-disable-next-line complexity
const prepareAboutSectionListItems = ({
  rule,
  hideName,
  hideDescription
}) => {
  const aboutSectionListItems = [];
  if (!hideName && rule.name) {
    aboutSectionListItems.push({
      title: i18n.NAME_FIELD_LABEL,
      description: /*#__PURE__*/_react.default.createElement(Name, {
        name: rule.name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 293,
          columnNumber: 20
        }
      })
    });
  }
  if (!hideDescription && rule.description) {
    aboutSectionListItems.push({
      title: i18n.DESCRIPTION_FIELD_LABEL,
      description: /*#__PURE__*/_react.default.createElement(Description, {
        description: rule.description,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 300,
          columnNumber: 20
        }
      })
    });
  }
  if (rule.author && rule.author.length > 0) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "authorPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 306,
          columnNumber: 14
        }
      }, i18n.AUTHOR_FIELD_LABEL),
      description: /*#__PURE__*/_react.default.createElement(Author, {
        author: rule.author,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 307,
          columnNumber: 20
        }
      })
    });
  }
  if (rule.building_block_type) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "buildingBlockPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 314,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "building_block",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 315,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(BuildingBlock, {
        type: "default",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 318,
          columnNumber: 20
        }
      })
    });
  }
  if (rule.severity) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "severityPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 325,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "severity",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 326,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
        value: rule.severity,
        "data-test-subj": "severityPropertyValue",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 329,
          columnNumber: 20
        }
      })
    });
  }
  if (rule.severity_mapping && rule.severity_mapping.length > 0) {
    aboutSectionListItems.push(...rule.severity_mapping.filter(severityMappingItem => severityMappingItem.field !== '').map((severityMappingItem, index) => {
      return {
        title: index === 0 ? /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "severityOverridePropertyTitle",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 341,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
          fieldName: "severity_mapping",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 342,
            columnNumber: 19
          }
        })) : '',
        description: /*#__PURE__*/_react.default.createElement(SeverityMappingItem, {
          severityMappingItem: severityMappingItem,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 347,
            columnNumber: 26
          }
        })
      };
    }));
  }
  if (rule.risk_score) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "riskScorePropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 356,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "risk_score",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 357,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(RiskScore, {
        riskScore: rule.risk_score,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 360,
          columnNumber: 20
        }
      })
    });
  }
  if (rule.risk_score_mapping && rule.risk_score_mapping.length > 0) {
    aboutSectionListItems.push(...rule.risk_score_mapping.filter(riskScoreMappingItem => riskScoreMappingItem.field !== '').map((riskScoreMappingItem, index) => {
      return {
        title: index === 0 ? /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": "riskScoreOverridePropertyTitle",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 372,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
          fieldName: "risk_score_mapping",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 373,
            columnNumber: 19
          }
        })) : '',
        description: /*#__PURE__*/_react.default.createElement(RiskScoreMappingItem, {
          riskScoreMappingItem: (0, _zodHelpers.requiredOptional)(riskScoreMappingItem),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 379,
            columnNumber: 15
          }
        })
      };
    }));
  }
  if (rule.references && rule.references.length > 0) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "referencesPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 389,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "references",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 390,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(References, {
        references: rule.references,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 393,
          columnNumber: 20
        }
      })
    });
  }
  if (rule.false_positives && rule.false_positives.length > 0) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "falsePositivesPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 400,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "false_positives",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 401,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(FalsePositives, {
        falsePositives: rule.false_positives,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 404,
          columnNumber: 20
        }
      })
    });
  }
  if (rule.investigation_fields && rule.investigation_fields.field_names.length > 0) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "investigationFieldsPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 411,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "investigation_fields",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 412,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(InvestigationFields, {
        investigationFields: rule.investigation_fields.field_names,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 416,
          columnNumber: 9
        }
      })
    });
  }
  if (rule.license) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "licensePropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 423,
          columnNumber: 14
        }
      }, i18n.LICENSE_FIELD_LABEL),
      description: /*#__PURE__*/_react.default.createElement(License, {
        license: rule.license,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 424,
          columnNumber: 20
        }
      })
    });
  }
  if (rule.rule_name_override) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "ruleNameOverridePropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 431,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "rule_name_override",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 432,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(RuleNameOverride, {
        ruleNameOverride: rule.rule_name_override,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 435,
          columnNumber: 20
        }
      })
    });
  }
  if (rule.threat && rule.threat.length > 0) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "threatPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 442,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "threat",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 443,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(Threat, {
        threat: rule.threat,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 446,
          columnNumber: 20
        }
      })
    });
  }
  if ('threat_indicator_path' in rule && rule.threat_indicator_path) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "threatIndicatorPathPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 453,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "threat_indicator_path",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 454,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(ThreatIndicatorPath, {
        threatIndicatorPath: rule.threat_indicator_path,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 457,
          columnNumber: 20
        }
      })
    });
  }
  if (rule.timestamp_override) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "timestampOverridePropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 464,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "timestamp_override",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 465,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(TimestampOverride, {
        timestampOverride: rule.timestamp_override,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 468,
          columnNumber: 20
        }
      })
    });
  }
  if (rule.max_signals) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "maxSignalsPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 475,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "max_signals",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 476,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(MaxSignals, {
        maxSignals: rule.max_signals,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 479,
          columnNumber: 20
        }
      })
    });
  }
  if (rule.tags && rule.tags.length > 0) {
    aboutSectionListItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "tagsPropertyTitle",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 486,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
        fieldName: "tags",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 487,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(Tags, {
        tags: rule.tags,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 490,
          columnNumber: 20
        }
      })
    });
  }
  return aboutSectionListItems;
};
const RuleAboutSection = ({
  rule,
  columnWidths = _constants.DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS,
  hideName,
  hideDescription,
  ...descriptionListProps
}) => {
  var _descriptionListProps, _descriptionListProps2;
  const aboutSectionListItems = prepareAboutSectionListItems({
    rule,
    hideName,
    hideDescription
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 518,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 519,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, (0, _extends2.default)({
    type: (_descriptionListProps = descriptionListProps.type) !== null && _descriptionListProps !== void 0 ? _descriptionListProps : 'column',
    rowGutterSize: (_descriptionListProps2 = descriptionListProps.rowGutterSize) !== null && _descriptionListProps2 !== void 0 ? _descriptionListProps2 : 'm',
    listItems: aboutSectionListItems,
    columnWidths: columnWidths,
    "data-test-subj": "listItemColumnStepRuleDescription"
  }, descriptionListProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 520,
      columnNumber: 7
    }
  })));
};
exports.RuleAboutSection = RuleAboutSection;