"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaxSignals = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _css = require("@emotion/css");
var _constants = require("../../../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../../common/lib/kibana");
var _max_signals_validator_factory = require("../../validators/max_signals_validator_factory");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/max_signals/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_SIGNALS_FIELD_WIDTH = 200;
const MaxSignals = ({
  dataTestSubj,
  field,
  idAria,
  isDisabled,
  placeholder
}) => {
  const {
    setValue,
    value
  } = field;
  const {
    alerting
  } = (0, _kibana.useKibana)().services;
  const maxAlertsPerRun = alerting.getMaxAlertsPerRun();
  const {
    isInvalid,
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const hasWarning = (0, _react.useMemo)(() => typeof value === 'number' && !isNaN(value) && value > maxAlertsPerRun, [maxAlertsPerRun, value]);
  const handleMaxSignalsChange = (0, _react.useCallback)(e => {
    const maxSignalsValue = e.target.value;
    // Has to handle an empty string as the field is optional
    setValue(maxSignalsValue !== '' ? Number(maxSignalsValue.trim()) : '');
  }, [setValue]);
  const helpText = (0, _react.useMemo)(() => {
    const textToRender = [];
    if (hasWarning) {
      textToRender.push(/*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "warning",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 9
        }
      }, i18n.LESS_THAN_WARNING(maxAlertsPerRun)));
    }
    textToRender.push(i18n.MAX_SIGNALS_HELP_TEXT(_constants.DEFAULT_MAX_SIGNALS));
    return textToRender;
  }, [hasWarning, maxAlertsPerRun]);
  const describedByIds = (0, _react.useMemo)(() => idAria ? [idAria] : undefined, [idAria]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    css: (0, _css.css)`
        .euiFormControlLayout {
          width: ${MAX_SIGNALS_FIELD_WIDTH}px;
        }
      `,
    describedByIds: describedByIds,
    fullWidth: true,
    helpText: helpText,
    label: field.label,
    labelAppend: field.labelAppend,
    isInvalid: isInvalid,
    error: errorMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: isInvalid,
    value: value,
    onChange: handleMaxSignalsChange,
    isLoading: field.isValidating,
    placeholder: placeholder,
    "data-test-subj": dataTestSubj,
    disabled: isDisabled,
    append: hasWarning ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "warning",
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 30
      }
    }) : undefined,
    min: _max_signals_validator_factory.MIN_VALUE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }));
};
exports.MaxSignals = MaxSignals;
MaxSignals.displayName = 'MaxSignals';