"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentStatus = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _translations = require("./translations");
var _empty_value = require("../../../empty_value");
var _use_get_agent_status = require("../../../../../management/hooks/agents/use_get_agent_status");
var _use_test_id_generator = require("../../../../../management/hooks/use_test_id_generator");
var _host_constants = require("../../../../../management/pages/endpoint_hosts/view/host_constants");
var _agent_response_action_status = require("./agent_response_action_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/endpoint/agents/agent_status/agent_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EuiFlexGroupStyled = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  .isolation-status {
    margin-left: ${({
  theme
}) => theme.eui.euiSizeS};
  }
`;
/**
 * Display the agent status of a host that supports response actions.
 *
 * IMPORTANT: If using this component on a list view, ensure that `statusInfo` prop is used instead
 *            of `agentId` in order to ensure API calls are kept to a minimum and the list view
 *            remains more performant.
 */
const AgentStatus = exports.AgentStatus = /*#__PURE__*/_react.default.memo(({
  agentId,
  agentType,
  statusInfo,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const enableApiCall = (0, _react.useMemo)(() => {
    return !statusInfo || !agentId;
  }, [agentId, statusInfo]);
  const {
    data,
    isLoading,
    isFetched
  } = (0, _use_get_agent_status.useGetAgentStatus)(agentId !== null && agentId !== void 0 ? agentId : '', agentType, {
    enabled: enableApiCall
  });
  const agentStatus = (0, _react.useMemo)(() => {
    if (statusInfo) {
      return statusInfo;
    }
    return data === null || data === void 0 ? void 0 : data[agentId !== null && agentId !== void 0 ? agentId : ''];
  }, [agentId, data, statusInfo]);
  const isCurrentlyIsolated = Boolean(agentStatus === null || agentStatus === void 0 ? void 0 : agentStatus.isolated);
  const [hasPendingActions, hostPendingActions] = (0, _react.useMemo)(() => {
    const pendingActions = agentStatus === null || agentStatus === void 0 ? void 0 : agentStatus.pendingActions;
    if (!pendingActions) {
      return [false, {}];
    }
    return [Object.keys(pendingActions).length > 0, pendingActions];
  }, [agentStatus === null || agentStatus === void 0 ? void 0 : agentStatus.pendingActions]);
  return /*#__PURE__*/_react.default.createElement(EuiFlexGroupStyled, {
    gutterSize: "none",
    responsive: false,
    className: "eui-textTruncate",
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, isFetched && !isLoading && agentStatus ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: _host_constants.HOST_STATUS_TO_BADGE_COLOR[agentStatus.status],
    className: "eui-textTruncate",
    "data-test-subj": getTestId('agentStatus'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, (0, _translations.getAgentStatusText)(agentStatus.status)) : (0, _empty_value.getEmptyTagValue)()), (isCurrentlyIsolated || hasPendingActions) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate isolation-status",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_response_action_status.AgentResponseActionsStatus, {
    "data-test-subj": getTestId('actionStatuses'),
    isIsolated: isCurrentlyIsolated,
    pendingActions: hostPendingActions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  })));
});
AgentStatus.displayName = 'AgentStatus';