"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _schema = require("./schema");
var _connector_selector_field = require("../form_fields/connector_selector_field");
var _schedule_field = require("../form_fields/schedule_field");
var _use_settings_view = require("../../hooks/use_settings_view");
var _rule_actions_field = require("../../../../../common/components/rule_actions_field");
var _kibana = require("../../../../../common/lib/kibana");
var _shared_imports = require("../../../../../shared_imports");
var _message_variables = require("./message_variables");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/schedule/edit_form/edit_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const EditForm = exports.EditForm = /*#__PURE__*/_react.default.memo(props => {
  const {
    initialValue,
    onChange,
    onFormMutated
  } = props;
  const {
    triggersActionsUi: {
      actionTypeRegistry
    }
  } = (0, _kibana.useKibana)().services;
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: initialValue,
    options: {
      stripEmptyFields: false
    },
    schema: (0, _schema.getSchema)({
      actionTypeRegistry
    })
  });
  const [{
    value
  }] = (0, _shared_imports.useFormData)({
    form
  });
  const {
    isValid,
    setFieldValue,
    submit
  } = form;
  (0, _react.useEffect)(() => {
    onChange({
      value,
      isValid,
      submit
    });
  }, [isValid, onChange, submit, value]);
  const [settings, setSettings] = (0, _react.useState)(initialValue.alertsSelectionSettings);
  const onSettingsChanged = (0, _react.useCallback)(newSettings => {
    setSettings(newSettings);
    setFieldValue('alertsSelectionSettings', newSettings);
    onFormMutated === null || onFormMutated === void 0 ? void 0 : onFormMutated();
  }, [onFormMutated, setFieldValue]);
  const [connectorId, setConnectorId] = _react.default.useState(initialValue === null || initialValue === void 0 ? void 0 : initialValue.connectorId);
  const onConnectorIdSelected = (0, _react.useCallback)(selectedConnectorId => {
    setConnectorId(selectedConnectorId);
    setFieldValue('connectorId', selectedConnectorId);
    onFormMutated === null || onFormMutated === void 0 ? void 0 : onFormMutated();
  }, [onFormMutated, setFieldValue]);
  const {
    settingsView
  } = (0, _use_settings_view.useSettingsView)({
    connectorId,
    onConnectorIdSelected,
    onSettingsChanged,
    settings,
    showConnectorSelector: false
  });
  const messageVariables = (0, _react.useMemo)(() => {
    return (0, _message_variables.getMessageVariables)();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "attackDiscoveryScheduleForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "name",
    componentProps: {
      'data-test-subj': 'attackDiscoveryFormNameField',
      euiFieldProps: {
        'data-test-subj': 'attackDiscoveryFormNameInput',
        autoFocus: true
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "connectorId",
    component: _connector_selector_field.ConnectorSelectorField,
    componentProps: {
      connectorId,
      onConnectorIdSelected
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "alertsSelectionSettings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }, () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, settingsView))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "interval",
    component: _schedule_field.ScheduleField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "actions",
    component: _rule_actions_field.RuleActionsField,
    componentProps: {
      ruleTypeId: _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_ALERT_TYPE_ID,
      messageVariables,
      defaultRuleFrequency: {
        notifyWhen: _common.RuleNotifyWhen.ACTIVE,
        throttle: null,
        summary: false
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }))));
});
EditForm.displayName = 'EditForm';