"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RESET_FIELD = exports.PreviewTab = exports.ATTACK_DISCOVERY_SETTINGS_ALERTS_COUNT_ID = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _fp = require("lodash/fp");
var _react2 = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _use_combo_box_reset = require("../../../../../common/components/use_combo_box_reset");
var _components = require("../../../../../detections/components/alerts_kpis/common/components");
var _use_signal_index = require("../../../../../detections/containers/detection_engine/alerts/use_signal_index");
var _kibana = require("../../../../../common/lib/kibana");
var _store = require("../../../../../sourcerer/store");
var _model = require("../../../../../sourcerer/store/model");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/alert_selection/preview_tab/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ATTACK_DISCOVERY_SETTINGS_ALERTS_COUNT_ID = exports.ATTACK_DISCOVERY_SETTINGS_ALERTS_COUNT_ID = 'attack-discovery-settings-alerts-count';
const RESET_FIELD = exports.RESET_FIELD = 'kibana.alert.rule.name';
const DEFAULT_DATA_TEST_SUBJ = 'previewTab';
const VIEW_MODE = 'view';
const PreviewTabComponent = ({
  dataTestSubj = DEFAULT_DATA_TEST_SUBJ,
  embeddableId,
  end,
  filters,
  getLensAttributes,
  getPreviewEsqlQuery,
  maxAlerts,
  query,
  setTableStackBy0,
  sorting,
  start,
  tableStackBy0
}) => {
  const {
    lens
  } = (0, _kibana.useKibana)().services;
  const {
    euiTheme: {
      font
    }
  } = (0, _eui.useEuiTheme)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const {
    comboboxRef: stackByField0ComboboxRef,
    setComboboxInputRef: setStackByField0ComboboxInputRef
  } = (0, _use_combo_box_reset.useEuiComboBoxReset)();
  const onSelect = (0, _react2.useCallback)(value => setTableStackBy0(value), [setTableStackBy0]);
  const timeRange = (0, _react2.useMemo)(() => ({
    from: start,
    to: end
  }), [end, start]);
  const esqlQuery = (0, _react2.useMemo)(() => getPreviewEsqlQuery({
    alertsIndexPattern: signalIndexName !== null && signalIndexName !== void 0 ? signalIndexName : '',
    maxAlerts,
    tableStackBy0
  }), [getPreviewEsqlQuery, maxAlerts, signalIndexName, tableStackBy0]);
  const attributes = (0, _react2.useMemo)(() => getLensAttributes({
    esqlQuery,
    sorting,
    tableStackBy0: tableStackBy0.trim()
  }), [esqlQuery, getLensAttributes, sorting, tableStackBy0]);
  const onReset = (0, _react2.useCallback)(() => {
    var _stackByField0Combobo;
    // clear the input when it's in an error state, i.e. because the user entered an invalid field:
    (_stackByField0Combobo = stackByField0ComboboxRef.current) === null || _stackByField0Combobo === void 0 ? void 0 : _stackByField0Combobo.clearSearchValue();
    setTableStackBy0(RESET_FIELD);
  }, [setTableStackBy0, stackByField0ComboboxRef]);
  const actions = (0, _react2.useMemo)(() => [/*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    "data-test-subj": "reset",
    onClick: onReset,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, i18n.RESET)], [onReset]);
  const body = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    "data-test-subj": "body",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }, i18n.SELECT_A_FIELD), []);
  const EmptyPrompt = (0, _react2.useMemo)(() => (0, _fp.isEmpty)(tableStackBy0.trim()) ? /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "emptyPrompt",
    actions: actions,
    body: body,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }) : null, [actions, body, tableStackBy0]);
  (0, _react2.useEffect)(() => {
    if (signalIndexName != null) {
      // Limit the fields in the StackByComboBox to the fields in the signal index.
      // NOTE: The page containing this component must also be a member of
      // `detectionsPaths` in `sourcerer/containers/sourcerer_paths.ts` for this
      // action to have any effect.
      dispatch(_store.sourcererActions.setSelectedDataView({
        id: _model.SourcererScopeName.detections,
        selectedDataViewId: signalIndexName,
        selectedPatterns: [signalIndexName],
        shouldValidateSelectedPatterns: false
      }));
    }
  }, [dispatch, signalIndexName]);
  if (signalIndexName == null) {
    return null;
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": dataTestSubj,
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_components.StackByComboBox, {
    "aria-label": i18n.SELECT_FIELD,
    "data-test-subj": "selectField",
    inputRef: setStackByField0ComboboxInputRef,
    onSelect: onSelect,
    prepend: '',
    ref: stackByField0ComboboxRef,
    selected: tableStackBy0,
    useLensCompatibleFields: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  }, EmptyPrompt !== null && EmptyPrompt !== void 0 ? EmptyPrompt : attributes && /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
                .euiDataGridHeader {
                  background: none;
                  border-top: none;
                }

                .euiDataGridHeaderCell {
                  font-size: ${font.scale.s}${font.defaultUnits};
                }

                .euiDataGridFooter {
                  background: none;
                }

                .euiDataGridRowCell {
                  font-size: ${font.scale.xs}${font.defaultUnits} !important;
                }

                .expExpressionRenderer__expression {
                  padding: 0 !important;
                }
              `,
    "data-test-subj": "embeddableContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(lens.EmbeddableComponent, {
    attributes: attributes,
    disableTriggers: false,
    filters: filters,
    hidePanelTitles: true,
    id: embeddableId,
    query: query,
    timeRange: timeRange,
    viewMode: VIEW_MODE,
    withDefaultActions: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 15
    }
  }))));
};
PreviewTabComponent.displayName = 'PreviewTab';
const PreviewTab = exports.PreviewTab = /*#__PURE__*/_react2.default.memo(PreviewTabComponent);