"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KillProcessRouteRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _base = require("../../common/base");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// --------------------------------------------------
// Tests for this module are at:
// x-pack/solutions/security/plugins/security_solution/common/endpoint/schema/actions.test.ts:604
// --------------------------------------------------

const KillProcessRouteRequestSchema = exports.KillProcessRouteRequestSchema = {
  body: _configSchema.schema.object({
    ..._base.BaseActionRequestSchema,
    parameters: _configSchema.schema.oneOf([_configSchema.schema.object({
      pid: _configSchema.schema.number({
        min: 1
      })
    }), _configSchema.schema.object({
      entity_id: _configSchema.schema.string({
        minLength: 1
      })
    }),
    // Process Name currently applies only to SentinelOne (validated below)
    _configSchema.schema.object({
      process_name: _configSchema.schema.string({
        minLength: 1
      })
    })])
  }, {
    validate(bodyContent) {
      if ('process_name' in bodyContent.parameters && bodyContent.agent_type !== 'sentinel_one') {
        return `[parameters.process_name]: is not valid with agent type of ${bodyContent.agent_type}`;
      }
      if (bodyContent.agent_type === 'sentinel_one' && !('process_name' in bodyContent.parameters)) {
        return `[parameters.process_name]: missing parameter for agent type of ${bodyContent.agent_type}`;
      }
    }
  })
};