"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RevertPrebuiltRulesResponseBody = exports.RevertPrebuiltRulesRequest = exports.BulkRevertSkipReasonEnum = exports.BulkRevertSkipReason = exports.BulkActionReversionSkipResult = void 0;
var _zod = require("@kbn/zod");
var _rule_schemas = require("../../model/rule_schema/rule_schemas.gen");
var _rule_management = require("../../rule_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RevertPrebuiltRulesRequest = exports.RevertPrebuiltRulesRequest = _zod.z.object({
  /** ID of rule to revert */
  id: _zod.z.string(),
  /** Revision of rule to guard against concurrence */
  revision: _zod.z.number(),
  /** Version of rule to guard against concurrence */
  version: _zod.z.number()
});
const BulkRevertSkipReason = exports.BulkRevertSkipReason = _zod.z.enum(['RULE_NOT_PREBUILT', 'RULE_NOT_CUSTOMIZED']);
const BulkRevertSkipReasonEnum = exports.BulkRevertSkipReasonEnum = BulkRevertSkipReason.enum;
const BulkActionReversionSkipResult = exports.BulkActionReversionSkipResult = _zod.z.object({
  id: _zod.z.string(),
  skip_reason: BulkRevertSkipReason
});
const RevertPrebuiltRulesResponseBody = exports.RevertPrebuiltRulesResponseBody = _zod.z.object({
  success: _zod.z.boolean().optional(),
  status_code: _zod.z.number().int().optional(),
  message: _zod.z.string().optional(),
  rules_count: _zod.z.number().int().optional(),
  attributes: _zod.z.object({
    results: _zod.z.object({
      updated: _zod.z.array(_rule_schemas.RuleResponse),
      // An array of the rule objects reverted to their base version
      created: _zod.z.array(_rule_schemas.RuleResponse),
      deleted: _zod.z.array(_rule_schemas.RuleResponse),
      skipped: _zod.z.array(BulkActionReversionSkipResult) // An array of the rule ids and reasons that were skipped during reversion (due to being already non-customized)
    }),
    summary: _zod.z.object({
      failed: _zod.z.number().int(),
      skipped: _zod.z.number().int(),
      succeeded: _zod.z.number().int(),
      total: _zod.z.number().int()
    }),
    errors: _zod.z.array(_rule_management.NormalizedRuleError).optional() // An array of error objects, something containing the id of the rule causing the error and the reason behind it (e.g. no base version, rule is not a prebuilt Elastic rule)
  })
});