"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocLink = void 0;
exports.useDocLinks = useDocLinks;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/components/doc_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Creates links to the documentation.
 *
 * @see {@link DocLink} for a component that creates a link to the docs.
 *
 * @example
 * ```typescript
 * <DocLink app="elasticsearch" doc="built-in-roles.html">
 *   Learn what privileges individual roles grant.
 * </DocLink>
 * ```
 *
 * @example
 * ```typescript
 * const [docs] = useDocLinks();
 *
 * <EuiLink href={docs.dashboard.guide} target="_blank" external>
 *   Learn how to get started with dashboards.
 * </EuiLink>
 * ```
 */
function useDocLinks() {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    links,
    ELASTIC_WEBSITE_URL,
    DOC_LINK_VERSION
  } = services.docLinks;
  const getDocLink = (0, _react.useCallback)((app, doc) => {
    return `${ELASTIC_WEBSITE_URL}guide/en/${app}/reference/${DOC_LINK_VERSION}/${doc}`;
  }, [ELASTIC_WEBSITE_URL, DOC_LINK_VERSION]);
  return [links, getDocLink];
}
const DocLink = ({
  app,
  doc,
  children
}) => {
  const [, getDocLink] = useDocLinks();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: getDocLink(app, doc),
    target: "_blank",
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, children);
};
exports.DocLink = DocLink;